/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.handler;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.examples.common.Messages;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public final class SaveDiagramAsImageHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject eObject;
        Resource resource;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        if (!(first instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)first;
        URI diagramFileUri = GraphitiUiInternal.getEmfService().getFileURI(file);
        URI diagramUri = GraphitiUiInternal.getEmfService().mapDiagramFileUriToDiagramUri(diagramFileUri);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
        if (editingDomain == null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
        }
        if ((resource = editingDomain.getResourceSet().getResource(diagramFileUri, false)) == null) {
            resource = editingDomain.getResourceSet().getResource(diagramFileUri, true);
        }
        if (!((eObject = editingDomain.getResourceSet().getEObject(diagramUri, false)) instanceof Diagram)) {
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SaveDiagramAsImageHandler_NoDiagramFoundError, (String)Messages.SaveDiagramAsImageHandler_NoDiagramFoundDialogText, (IStatus)Status.CANCEL_STATUS);
            return null;
        }
        Diagram diagram = (Diagram)eObject;
        byte[] bytes = GraphitiUi.getImageService().convertDiagramToBytes(diagram, 4);
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.jpg", "*.*"});
        dialog.setFilterIndex(0);
        dialog.setText(Messages.SaveDiagramAsImageHandler_DialogTitle);
        dialog.setFileName(file.getName());
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(fileName);
                fos.write(bytes);
            }
            catch (FileNotFoundException e) {
                Object object = this.showFileSelectionErrorDialog(e);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    return this.showFileSelectionErrorDialog(e2);
                }
                return object;
            }
            catch (IOException e) {
                Object object = this.showFileSelectionErrorDialog(e);
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e3) {
                    return this.showFileSelectionErrorDialog(e3);
                }
                return object;
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                return this.showFileSelectionErrorDialog(e);
            }
        }
        editingDomain.dispose();
        return null;
    }

    private Object showFileSelectionErrorDialog(IOException e) {
        Status status = new Status(4, "org.eclipse.graphiti.examples.common", e.getMessage(), (Throwable)e);
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.SaveDiagramAsImageHandler_SaveFileError, (String)e.getMessage(), (IStatus)status);
        return null;
    }
}

