/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class Ellipse
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int WMF_BOTTOM_OFFSET = 0;
    private static final int WMF_RIGHT_OFFSET = 2;
    private static final int WMF_TOP_OFFSET = 4;
    private static final int WMF_LEFT_OFFSET = 6;
    private Rectangle m_rect;

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        short bottom = rec.getShortAt(0);
        short right = rec.getShortAt(2);
        short top = rec.getShortAt(4);
        short left = rec.getShortAt(6);
        this.m_rect = new Rectangle(left, top, right - left, bottom - top);
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        this.m_rect = rec.getRectangleLAt(0);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen pen;
        Shape shape = this.getShape(context);
        GdiBrush brush = context.getCurBrush();
        if (brush != null) {
            brush.fill(shape, g, context);
        }
        if ((pen = context.getCurPen()) != null) {
            pen.apply(g, context);
            g.draw(shape);
        }
    }

    @Override
    public void render(DeviceContext context) throws TranscoderException {
        Shape shape = this.getShape(context);
        context.getGdiPath().appendFigure(shape);
    }

    private Shape getShape(DeviceContext context) {
        int x = context.convertXToSVGLogicalUnits(this.m_rect.x);
        int y = context.convertYToSVGLogicalUnits(this.m_rect.y);
        int w = context.scaleX(this.m_rect.width);
        int h = context.scaleY(this.m_rect.height);
        Ellipse2D.Double shape = new Ellipse2D.Double(x, y, w, h);
        return shape;
    }
}

