/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg;

import java.awt.Color;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.traversal.NodeIterator;

public class SVGColorConverter {
    private static SVGColorConverter INSTANCE = new SVGColorConverter();
    public static final String SEMICOLON = ";";
    public static final String COLON = ":";

    public static SVGColorConverter getInstance() {
        return INSTANCE;
    }

    private SVGColorConverter() {
    }

    public void replaceDocumentColors(SVGOMDocument svgDoc, Color fillColor, Color outlineColor) {
        SVGSVGElement svgRoot = svgDoc.getRootElement();
        NodeIterator ni = svgDoc.createNodeIterator((Node)svgRoot, -1, null, true);
        Node node = ni.nextNode();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (fillColor != null) {
                    this.setColorAttribute(svgDoc, element, "fill", false, fillColor);
                    this.setColorAttribute(svgDoc, element, "stop-color", false, fillColor);
                }
                if (outlineColor != null) {
                    this.setColorAttribute(svgDoc, element, "stroke", true, outlineColor);
                    this.setColorAttribute(svgDoc, element, "stop-color", true, outlineColor);
                }
            }
            node = ni.nextNode();
        }
    }

    private boolean isBlack(String color) {
        String cleanColorStr = this.cleanFromSpaces(color);
        return cleanColorStr.equals("#000000") || cleanColorStr.equalsIgnoreCase("BLACK") || cleanColorStr.equalsIgnoreCase("rgb(0,0,0)");
    }

    private boolean isWhite(String color) {
        String cleanColorStr = this.cleanFromSpaces(color);
        return cleanColorStr.equalsIgnoreCase("#FFFFFF") || cleanColorStr.equalsIgnoreCase("WHITE") || cleanColorStr.equalsIgnoreCase("rgb(255,255,255)");
    }

    private String cleanFromSpaces(String s) {
        char[] chars = new char[s.length()];
        int index = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                chars[index++] = s.charAt(i);
            }
            ++i;
        }
        return new String(chars, 0, index);
    }

    protected void setColorAttribute(SVGOMDocument svgDoc, Element element, String attributeName, boolean black, Color color) {
        SVGPaintDescriptor svgPD = SVGColor.toSVG((Color)color, (SVGGeneratorContext)SVGGeneratorContext.createDefault((Document)svgDoc));
        if (element.hasAttribute(attributeName)) {
            String value = element.getAttribute(attributeName);
            if ((attributeName.equals("stroke") || attributeName.equals("fill")) && (black && this.isBlack(value) || !black && this.isWhite(value))) {
                element.setAttribute(attributeName, svgPD.getPaintValue());
            }
        } else if (element.hasAttribute("style")) {
            String style = element.getAttribute("style");
            String preColor = "";
            int nStart = style.indexOf(String.valueOf(attributeName) + COLON);
            if (nStart != -1) {
                if (nStart > 0) {
                    preColor = style.substring(0, nStart);
                }
                String postColor = "";
                int nEnd = style.indexOf(SEMICOLON, nStart);
                if (nEnd == -1) {
                    nEnd = style.length();
                }
                if (nEnd < style.length() - 1) {
                    postColor = style.substring(nEnd + 1, style.length());
                }
                String currentColor = style.substring(nStart + attributeName.length() + 1, nEnd);
                if ((black && this.isBlack(currentColor) || !black && this.isWhite(currentColor)) && !currentColor.equals("none")) {
                    StringBuffer styleBuffer = new StringBuffer(style.length() + 5);
                    styleBuffer.append(preColor);
                    styleBuffer.append(" ");
                    styleBuffer.append(attributeName);
                    styleBuffer.append(COLON);
                    styleBuffer.append(svgPD.getPaintValue());
                    if (!postColor.equals("")) {
                        styleBuffer.append(SEMICOLON);
                        styleBuffer.append(postColor);
                    }
                    String styleNew = styleBuffer.toString();
                    element.setAttribute("style", styleNew);
                }
            }
        }
    }
}

