/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.equinox.p2.internal.repository.comparator.java.CharOperation;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileReader;
import org.eclipse.equinox.p2.internal.repository.comparator.java.FieldInfo;
import org.eclipse.equinox.p2.internal.repository.comparator.java.MethodInfo;
import org.eclipse.equinox.p2.internal.repository.comparator.java.Signature;

public class Utility {
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final String EMPTY_STRING = "";
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] INIT = "<init>".toCharArray();

    public static byte[] getZipEntryByteContent(ZipEntry ze, ZipFile zip) throws IOException {
        InputStream stream = null;
        try {
            stream = zip.getInputStream(ze);
            if (stream == null) {
                throw new IOException("Invalid zip entry name : " + ze.getName());
            }
            byte[] byArray = Utility.getInputStreamAsByteArray(stream, (int)ze.getSize());
            return byArray;
        }
        finally {
            Utility.close(stream);
        }
    }

    public static void close(Object object) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof InputStream) {
                ((InputStream)object).close();
            } else if (object instanceof OutputStream) {
                ((OutputStream)object).close();
            } else if (object instanceof ZipFile) {
                ((ZipFile)object).close();
            }
        }
        catch (IOException iOException) {}
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static ClassFileAttribute getAttribute(MethodInfo methodInfo, char[] attributeName) {
        ClassFileAttribute[] attributes;
        ClassFileAttribute[] classFileAttributeArray = attributes = methodInfo.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), attributeName)) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static ClassFileAttribute getAttribute(FieldInfo fieldInfo, char[] attributeName) {
        ClassFileAttribute[] attributes;
        ClassFileAttribute[] classFileAttributeArray = attributes = fieldInfo.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), attributeName)) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static ClassFileAttribute getAttribute(ClassFileReader classFileReader, char[] attributeName) {
        ClassFileAttribute[] attributes;
        ClassFileAttribute[] classFileAttributeArray = attributes = classFileReader.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ClassFileAttribute attribute = classFileAttributeArray[n2];
            if (Arrays.equals(attribute.getAttributeName(), attributeName)) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static int scanTypeSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '[': {
                return Utility.scanArrayTypeSignature(string, start);
            }
            case 'L': 
            case 'Q': {
                return Utility.scanClassTypeSignature(string, start);
            }
            case 'T': {
                return Utility.scanTypeVariableSignature(string, start);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return Utility.scanBaseTypeSignature(string, start);
            }
            case '!': {
                return Utility.scanCaptureTypeSignature(string, start);
            }
            case '*': 
            case '+': 
            case '-': {
                return Utility.scanTypeBoundSignature(string, start);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanBaseTypeSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if ("BCDFIJSVZ".indexOf(c) >= 0) {
            return start;
        }
        throw new IllegalArgumentException();
    }

    public static int scanArrayTypeSignature(char[] string, int start) {
        int length = string.length;
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        c = string[++start];
        while (c == '[') {
            if (start >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[++start];
        }
        return Utility.scanTypeSignature(string, start);
    }

    public static int scanCaptureTypeSignature(char[] string, int start) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '!') {
            throw new IllegalArgumentException();
        }
        return Utility.scanTypeBoundSignature(string, start + 1);
    }

    public static int scanTypeVariableSignature(char[] string, int start) {
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'T') {
            throw new IllegalArgumentException();
        }
        int id = Utility.scanIdentifier(string, start + 1);
        c = string[id + 1];
        if (c == ';') {
            return id + 1;
        }
        throw new IllegalArgumentException();
    }

    public static int scanIdentifier(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        int p = start;
        do {
            char c;
            if ((c = string[p]) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return p - 1;
        } while (++p != string.length);
        return p - 1;
    }

    public static int scanClassTypeSignature(char[] string, int start) {
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            return -1;
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
                case '<': {
                    int e;
                    p = e = Utility.scanTypeArgumentSignatures(string, p);
                    break;
                }
                case '.': 
                case '/': {
                    int id;
                    p = id = Utility.scanIdentifier(string, p + 1);
                    break;
                }
            }
            ++p;
        }
    }

    public static int scanTypeBoundSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '*': {
                return start;
            }
            case '+': 
            case '-': {
                if (start < string.length - 2) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        c = string[++start];
        switch (c) {
            case '!': {
                return Utility.scanCaptureTypeSignature(string, start);
            }
            case '+': 
            case '-': {
                return Utility.scanTypeBoundSignature(string, start);
            }
            case 'L': 
            case 'Q': {
                return Utility.scanClassTypeSignature(string, start);
            }
            case 'T': {
                return Utility.scanTypeVariableSignature(string, start);
            }
            case '[': {
                return Utility.scanArrayTypeSignature(string, start);
            }
            case '*': {
                return start;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int scanTypeArgumentSignatures(char[] string, int start) {
        if (start >= string.length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '<') {
            throw new IllegalArgumentException();
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            if (c == '>') {
                return p;
            }
            int e = Utility.scanTypeArgumentSignature(string, p);
            p = e + 1;
        }
    }

    public static int scanTypeArgumentSignature(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        switch (c) {
            case '*': {
                return start;
            }
            case '+': 
            case '-': {
                return Utility.scanTypeBoundSignature(string, start);
            }
        }
        return Utility.scanTypeSignature(string, start);
    }

    static void appendTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        char c = string[start];
        switch (c) {
            case '[': {
                Utility.appendArrayTypeSignature(string, start, buffer, compact);
                break;
            }
            case 'L': {
                Utility.appendClassTypeSignature(string, start, buffer, compact);
                break;
            }
            case 'T': {
                int e = Utility.scanTypeVariableSignature(string, start);
                buffer.append(string, start + 1, e - start - 1);
                break;
            }
            case 'Z': {
                buffer.append(BOOLEAN);
                break;
            }
            case 'B': {
                buffer.append(BYTE);
                break;
            }
            case 'C': {
                buffer.append(CHAR);
                break;
            }
            case 'D': {
                buffer.append(DOUBLE);
                break;
            }
            case 'F': {
                buffer.append(FLOAT);
                break;
            }
            case 'I': {
                buffer.append(INT);
                break;
            }
            case 'J': {
                buffer.append(LONG);
                break;
            }
            case 'S': {
                buffer.append(SHORT);
                break;
            }
            case 'V': {
                buffer.append(VOID);
            }
        }
    }

    private static void appendArrayTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        int length = string.length;
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int index = start;
        c = string[++index];
        while (c == '[') {
            if (index >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[++index];
        }
        Utility.appendTypeSignature(string, index, buffer, compact);
        int i = 0;
        int dims = index - start;
        while (i < dims) {
            buffer.append('[').append(']');
            ++i;
        }
    }

    private static void appendClassTypeSignature(char[] string, int start, StringBuffer buffer, boolean compact) {
        char c = string[start];
        if (c != 'L') {
            return;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        while (true) {
            c = string[p];
            switch (c) {
                case ';': {
                    return;
                }
                case '.': 
                case '/': {
                    if (compact) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '$': {
                    buffer.append('.');
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++p;
        }
    }

    public static String toString(char[] declaringClass, char[] methodName, char[] methodSignature, boolean includeReturnType, boolean compact) {
        boolean isConstructor = Arrays.equals(methodName, INIT);
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (declaringClass.length > 0) {
            char[] declaringClassSignature = null;
            if (declaringClass[0] == '[') {
                CharOperation.replace(declaringClass, '/', '.');
                declaringClassSignature = Signature.toCharArray(declaringClass);
            } else {
                CharOperation.replace(declaringClass, '/', '.');
                declaringClassSignature = declaringClass;
            }
            int lastIndexOfSlash = CharOperation.lastIndexOf('.', declaringClassSignature);
            if (compact && lastIndexOfSlash != -1) {
                buffer.append(declaringClassSignature, lastIndexOfSlash + 1, declaringClassSignature.length - lastIndexOfSlash - 1);
            } else {
                buffer.append(declaringClassSignature);
            }
        }
        if (!isConstructor) {
            buffer.append('.');
            if (methodName != null) {
                buffer.append(methodName);
            }
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int i = 0;
        int max = pts.length;
        while (i < max) {
            Utility.appendTypeSignature(pts[i], 0, buffer, compact);
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        if (!isConstructor) {
            buffer.append(" : ");
            if (includeReturnType) {
                char[] rts = Signature.getReturnType(methodSignature);
                Utility.appendTypeSignature(rts, 0, buffer, compact);
            }
        }
        return String.valueOf(buffer);
    }
}

