/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.pushstream.AbstractPushStreamImpl;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushStream;
import org.osgi.util.pushstream.PushStreamProvider;

class IntermediatePushStreamImpl<T>
extends AbstractPushStreamImpl<T>
implements PushStream<T> {
    private final AbstractPushStreamImpl<?> previous;

    IntermediatePushStreamImpl(PushStreamProvider psp, PromiseFactory promiseFactory, AbstractPushStreamImpl<?> previous) {
        super(psp, promiseFactory);
        this.previous = previous;
    }

    @Override
    protected boolean begin() {
        if (this.closed.compareAndSet(AbstractPushStreamImpl.State.BUILDING, AbstractPushStreamImpl.State.STARTED)) {
            this.beginning();
            this.previous.begin();
            return true;
        }
        return false;
    }

    protected void beginning() {
    }

    @Override
    protected void upstreamClose(PushEvent<?> close) {
        if (this.closed.get() != AbstractPushStreamImpl.State.CLOSED) {
            this.close(close.nodata(), false);
        }
        this.previous.upstreamClose(close);
    }
}

