/**
 * Copyright (c) 2016 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import static org.apache.commons.lang3.StringUtils.defaultString;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.epp.logging.aeri.ide.processors.AbstractCachingStringProcessor;

import com.google.common.annotations.VisibleForTesting;

public abstract class PlatformDetailsSectionProcessor extends AbstractCachingStringProcessor implements IReportProcessor {

    public String sectionTitle;

    public PlatformDetailsSectionProcessor(IProcessorDescriptor descriptor, String sectionTitle) {
        super(descriptor);
        this.sectionTitle = sectionTitle;
    }

    @Override
    public boolean canContribute(IStatus status) {
        // the contribution may be an empty string but pre-fetching the configuration is expensive
        // and may cause ui freezes (see https://bugs.eclipse.org/bugs/show_bug.cgi?id=507041)
        return true;
    }

    @Override
    public final boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    @VisibleForTesting
    protected String process(IStatus status) {
        String configuration = getPlatformDetailsConfiguration();
        int sectionStart = configuration.indexOf(sectionTitle);
        if (sectionStart == -1) {
            return "";
        }
        // omit the title
        sectionStart += sectionTitle.length();
        // end = begin of next section
        int sectionEnd = configuration.indexOf("*** ", sectionStart + 1) - 1;
        if (sectionEnd < 0) {
            // if no next section: end = next blank line
            sectionEnd = configuration.indexOf(System.lineSeparator() + System.lineSeparator(), sectionStart + 1) - 1;
            if (sectionEnd < 0) {
                // otherwise use everything left
                sectionEnd = configuration.length();
            }
        }
        return configuration.substring(sectionStart, sectionEnd).trim();
    }

    private String getPlatformDetailsConfiguration() {
        return defaultString(ConfigurationInfo.getConfiguration("Platform Details"));
    }

}
