/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marcel Bruch - initial API and implementation.
 */
package org.eclipse.epp.internal.logging.aeri.ide.custom;

import static org.eclipse.epp.logging.aeri.core.util.Logs.log;

import org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CustomServerDescriptor extends ServerDescriptorImpl {

    @Nullable
    private Image icon16;
    @Nullable
    private Image icon32;
    @Nullable
    private Image icon64;

    protected CustomServerDescriptor() {
    }

    @Override
    public synchronized Image getImage16() {
        if (icon16 == null) {
            icon16 = loadImage(getIcon16());
        }
        return icon16;
    }

    @Override
    public synchronized Image getImage32() {
        if (icon32 == null) {
            icon32 = loadImage(getIcon32());
        }
        return icon32;
    }

    private Image loadImage(String path) {
        try {
            return AbstractUIPlugin.imageDescriptorFromPlugin(getContributor(), path).createImage();
        } catch (Exception e) {
            log(LogMessages.WARN_SERVER_FAILURE, e, getId(), e.getMessage());
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
    }

    @Override
    public boolean isActive() {
        return isEnabled() && isConfigured();
    }

}
