/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.epp.logging.aeri.core.IModelPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory
 * @model kind="package"
 * @generated
 */
public interface IIdePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "ide";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "https://www.eclipse.org/epp/logging/aeri/ide/2.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "aeri";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	IIdePackage eINSTANCE = org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventsQueueImpl <em>Log Events Queue</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventsQueueImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEventsQueue()
	 * @generated
	 */
	int LOG_EVENTS_QUEUE = 0;

	/**
	 * The feature id for the '<em><b>Groups</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENTS_QUEUE__GROUPS = 0;

	/**
	 * The number of structural features of the '<em>Log Events Queue</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENTS_QUEUE_FEATURE_COUNT = 1;

	/**
	 * The operation id for the '<em>Add Group</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENTS_QUEUE___ADD_GROUP__ELIST = 0;

	/**
	 * The number of operations of the '<em>Log Events Queue</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENTS_QUEUE_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventGroupImpl <em>Log Event Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventGroupImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEventGroup()
	 * @generated
	 */
	int LOG_EVENT_GROUP = 1;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_GROUP__STATUS = 0;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_GROUP__EVENTS = 1;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_GROUP__TIMESTAMP = 2;

	/**
	 * The number of structural features of the '<em>Log Event Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_GROUP_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>Log Event Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_GROUP_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl <em>Log Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEvent()
	 * @generated
	 */
	int LOG_EVENT = 2;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__STATUS = 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__LABEL = 1;

	/**
	 * The feature id for the '<em><b>Server</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__SERVER = 2;

	/**
	 * The feature id for the '<em><b>Group</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__GROUP = 3;

	/**
	 * The feature id for the '<em><b>Interest</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__INTEREST = 4;

	/**
	 * The feature id for the '<em><b>Options</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__OPTIONS = 5;

	/**
	 * The feature id for the '<em><b>Response</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__RESPONSE = 6;

	/**
	 * The feature id for the '<em><b>Context</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT__CONTEXT = 7;

	/**
	 * The number of structural features of the '<em>Log Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Log Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOG_EVENT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.InternalInputImpl <em>Internal Input</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.InternalInputImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getInternalInput()
	 * @generated
	 */
	int INTERNAL_INPUT = 3;

	/**
	 * The feature id for the '<em><b>Input</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_INPUT__INPUT = 0;

	/**
	 * The number of structural features of the '<em>Internal Input</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_INPUT_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>Internal Input</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int INTERNAL_INPUT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl <em>Server Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getServerDescriptor()
	 * @generated
	 */
	int SERVER_DESCRIPTOR = 4;

	/**
	 * The feature id for the '<em><b>Links</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__LINKS = IModelPackage.LINKABLE__LINKS;

	/**
	 * The feature id for the '<em><b>Reporter Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__REPORTER_ID = IModelPackage.LINKABLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reporter Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__REPORTER_NAME = IModelPackage.LINKABLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reporter Email</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__REPORTER_EMAIL = IModelPackage.LINKABLE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Anonymize Messages</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ANONYMIZE_MESSAGES = IModelPackage.LINKABLE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Anonymize Stack Traces</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ANONYMIZE_STACK_TRACES = IModelPackage.LINKABLE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Disable Automatic Wiring Analysis</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__DISABLE_AUTOMATIC_WIRING_ANALYSIS = IModelPackage.LINKABLE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ID = IModelPackage.LINKABLE_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__NAME = IModelPackage.LINKABLE_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__DESCRIPTION = IModelPackage.LINKABLE_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Contributor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__CONTRIBUTOR = IModelPackage.LINKABLE_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Clazz</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__CLAZZ = IModelPackage.LINKABLE_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Icon16</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ICON16 = IModelPackage.LINKABLE_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Icon32</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ICON32 = IModelPackage.LINKABLE_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Connection</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__CONNECTION = IModelPackage.LINKABLE_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Configured</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__CONFIGURED = IModelPackage.LINKABLE_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__ENABLED = IModelPackage.LINKABLE_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT = IModelPackage.LINKABLE_FEATURE_COUNT + 16;

	/**
	 * The number of structural features of the '<em>Server Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR_FEATURE_COUNT = IModelPackage.LINKABLE_FEATURE_COUNT + 17;

	/**
	 * The operation id for the '<em>Get Image16</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR___GET_IMAGE16 = IModelPackage.LINKABLE_OPERATION_COUNT + 0;

	/**
	 * The operation id for the '<em>Get Image32</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR___GET_IMAGE32 = IModelPackage.LINKABLE_OPERATION_COUNT + 1;

	/**
	 * The operation id for the '<em>Is Active</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR___IS_ACTIVE = IModelPackage.LINKABLE_OPERATION_COUNT + 2;

	/**
	 * The number of operations of the '<em>Server Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVER_DESCRIPTOR_OPERATION_COUNT = IModelPackage.LINKABLE_OPERATION_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl <em>Processor Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getProcessorDescriptor()
	 * @generated
	 */
	int PROCESSOR_DESCRIPTOR = 5;

	/**
	 * The feature id for the '<em><b>Processor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__PROCESSOR = 0;

	/**
	 * The feature id for the '<em><b>Configuration Element</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Icon16</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__ICON16 = 3;

	/**
	 * The feature id for the '<em><b>Contributor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__CONTRIBUTOR = 4;

	/**
	 * The feature id for the '<em><b>Directive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__DIRECTIVE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__NAME = 6;

	/**
	 * The feature id for the '<em><b>Automatic</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__AUTOMATIC = 7;

	/**
	 * The number of structural features of the '<em>Processor Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR_FEATURE_COUNT = 8;

	/**
	 * The operation id for the '<em>Get Image16</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR___GET_IMAGE16 = 0;

	/**
	 * The number of operations of the '<em>Processor Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR_OPERATION_COUNT = 1;

	/**
	 * The meta object id for the '<em>Image</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.swt.graphics.Image
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getImage()
	 * @generated
	 */
	int IMAGE = 6;

	/**
	 * The meta object id for the '<em>Dialog</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.jface.dialogs.Dialog
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getDialog()
	 * @generated
	 */
	int DIALOG = 7;

	/**
	 * The meta object id for the '<em>Report Processor Safe Wrapper</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper
	 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getReportProcessorSafeWrapper()
	 * @generated
	 */
	int REPORT_PROCESSOR_SAFE_WRAPPER = 8;


	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue <em>Log Events Queue</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Log Events Queue</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue
	 * @generated
	 */
	EClass getLogEventsQueue();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue#getGroups <em>Groups</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Groups</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue#getGroups()
	 * @see #getLogEventsQueue()
	 * @generated
	 */
	EReference getLogEventsQueue_Groups();

	/**
	 * Returns the meta object for the '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue#addGroup(org.eclipse.emf.common.util.EList) <em>Add Group</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add Group</em>' operation.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue#addGroup(org.eclipse.emf.common.util.EList)
	 * @generated
	 */
	EOperation getLogEventsQueue__AddGroup__EList();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup <em>Log Event Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Log Event Group</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup
	 * @generated
	 */
	EClass getLogEventGroup();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getStatus()
	 * @see #getLogEventGroup()
	 * @generated
	 */
	EAttribute getLogEventGroup_Status();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getEvents <em>Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Events</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getEvents()
	 * @see #getLogEventGroup()
	 * @generated
	 */
	EReference getLogEventGroup_Events();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup#getTimestamp()
	 * @see #getLogEventGroup()
	 * @generated
	 */
	EAttribute getLogEventGroup_Timestamp();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent <em>Log Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Log Event</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent
	 * @generated
	 */
	EClass getLogEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getStatus()
	 * @see #getLogEvent()
	 * @generated
	 */
	EAttribute getLogEvent_Status();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getLabel <em>Label</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Label</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getLabel()
	 * @see #getLogEvent()
	 * @generated
	 */
	EAttribute getLogEvent_Label();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getServer <em>Server</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Server</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getServer()
	 * @see #getLogEvent()
	 * @generated
	 */
	EReference getLogEvent_Server();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup <em>Group</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Group</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getGroup()
	 * @see #getLogEvent()
	 * @generated
	 */
	EReference getLogEvent_Group();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getInterest <em>Interest</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Interest</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getInterest()
	 * @see #getLogEvent()
	 * @generated
	 */
	EReference getLogEvent_Interest();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getOptions <em>Options</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Options</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getOptions()
	 * @see #getLogEvent()
	 * @generated
	 */
	EReference getLogEvent_Options();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getResponse <em>Response</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Response</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getResponse()
	 * @see #getLogEvent()
	 * @generated
	 */
	EReference getLogEvent_Response();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Context</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.ILogEvent#getContext()
	 * @see #getLogEvent()
	 * @generated
	 */
	EAttribute getLogEvent_Context();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.IInternalInput <em>Internal Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Internal Input</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IInternalInput
	 * @generated
	 */
	EClass getInternalInput();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.epp.internal.logging.aeri.ide.IInternalInput#getInput <em>Input</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Input</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IInternalInput#getInput()
	 * @see #getInternalInput()
	 * @generated
	 */
	EReference getInternalInput_Input();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor <em>Server Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Server Descriptor</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor
	 * @generated
	 */
	EClass getServerDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getId()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getName()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getDescription()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getContributor <em>Contributor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contributor</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getContributor()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Contributor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getClazz <em>Clazz</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Clazz</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getClazz()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Clazz();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon16 <em>Icon16</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon16</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon16()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Icon16();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon32 <em>Icon32</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon32</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getIcon32()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Icon32();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConnection <em>Connection</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Connection</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConnection()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Connection();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isConfigured <em>Configured</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Configured</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isConfigured()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Configured();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isEnabled <em>Enabled</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enabled</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isEnabled()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_Enabled();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConfigurationElement <em>Configuration Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Configuration Element</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getConfigurationElement()
	 * @see #getServerDescriptor()
	 * @generated
	 */
	EAttribute getServerDescriptor_ConfigurationElement();

	/**
	 * Returns the meta object for the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getImage16() <em>Get Image16</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Image16</em>' operation.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getImage16()
	 * @generated
	 */
	EOperation getServerDescriptor__GetImage16();

	/**
	 * Returns the meta object for the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getImage32() <em>Get Image32</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Image32</em>' operation.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#getImage32()
	 * @generated
	 */
	EOperation getServerDescriptor__GetImage32();

	/**
	 * Returns the meta object for the '{@link org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isActive() <em>Is Active</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Is Active</em>' operation.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor#isActive()
	 * @generated
	 */
	EOperation getServerDescriptor__IsActive();

	/**
	 * Returns the meta object for class '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor <em>Processor Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Processor Descriptor</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor
	 * @generated
	 */
	EClass getProcessorDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getProcessor <em>Processor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Processor</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getProcessor()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Processor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getConfigurationElement <em>Configuration Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Configuration Element</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getConfigurationElement()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_ConfigurationElement();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDescription()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getIcon16 <em>Icon16</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Icon16</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getIcon16()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Icon16();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getContributor <em>Contributor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Contributor</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getContributor()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Contributor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDirective <em>Directive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Directive</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getDirective()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Directive();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getName()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#isAutomatic <em>Automatic</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Automatic</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#isAutomatic()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EAttribute getProcessorDescriptor_Automatic();

	/**
	 * Returns the meta object for the '{@link org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getImage16() <em>Get Image16</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Image16</em>' operation.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor#getImage16()
	 * @generated
	 */
	EOperation getProcessorDescriptor__GetImage16();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.swt.graphics.Image <em>Image</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Image</em>'.
	 * @see org.eclipse.swt.graphics.Image
	 * @model instanceClass="org.eclipse.swt.graphics.Image"
	 * @generated
	 */
	EDataType getImage();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.jface.dialogs.Dialog <em>Dialog</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Dialog</em>'.
	 * @see org.eclipse.jface.dialogs.Dialog
	 * @model instanceClass="org.eclipse.jface.dialogs.Dialog"
	 * @generated
	 */
	EDataType getDialog();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper <em>Report Processor Safe Wrapper</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Report Processor Safe Wrapper</em>'.
	 * @see org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper
	 * @model instanceClass="org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper"
	 * @generated
	 */
	EDataType getReportProcessorSafeWrapper();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	IIdeFactory getIdeFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventsQueueImpl <em>Log Events Queue</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventsQueueImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEventsQueue()
		 * @generated
		 */
		EClass LOG_EVENTS_QUEUE = eINSTANCE.getLogEventsQueue();

		/**
		 * The meta object literal for the '<em><b>Groups</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENTS_QUEUE__GROUPS = eINSTANCE.getLogEventsQueue_Groups();

		/**
		 * The meta object literal for the '<em><b>Add Group</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation LOG_EVENTS_QUEUE___ADD_GROUP__ELIST = eINSTANCE.getLogEventsQueue__AddGroup__EList();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventGroupImpl <em>Log Event Group</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventGroupImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEventGroup()
		 * @generated
		 */
		EClass LOG_EVENT_GROUP = eINSTANCE.getLogEventGroup();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOG_EVENT_GROUP__STATUS = eINSTANCE.getLogEventGroup_Status();

		/**
		 * The meta object literal for the '<em><b>Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT_GROUP__EVENTS = eINSTANCE.getLogEventGroup_Events();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOG_EVENT_GROUP__TIMESTAMP = eINSTANCE.getLogEventGroup_Timestamp();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl <em>Log Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.LogEventImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getLogEvent()
		 * @generated
		 */
		EClass LOG_EVENT = eINSTANCE.getLogEvent();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOG_EVENT__STATUS = eINSTANCE.getLogEvent_Status();

		/**
		 * The meta object literal for the '<em><b>Label</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOG_EVENT__LABEL = eINSTANCE.getLogEvent_Label();

		/**
		 * The meta object literal for the '<em><b>Server</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT__SERVER = eINSTANCE.getLogEvent_Server();

		/**
		 * The meta object literal for the '<em><b>Group</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT__GROUP = eINSTANCE.getLogEvent_Group();

		/**
		 * The meta object literal for the '<em><b>Interest</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT__INTEREST = eINSTANCE.getLogEvent_Interest();

		/**
		 * The meta object literal for the '<em><b>Options</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT__OPTIONS = eINSTANCE.getLogEvent_Options();

		/**
		 * The meta object literal for the '<em><b>Response</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOG_EVENT__RESPONSE = eINSTANCE.getLogEvent_Response();

		/**
		 * The meta object literal for the '<em><b>Context</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOG_EVENT__CONTEXT = eINSTANCE.getLogEvent_Context();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.InternalInputImpl <em>Internal Input</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.InternalInputImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getInternalInput()
		 * @generated
		 */
		EClass INTERNAL_INPUT = eINSTANCE.getInternalInput();

		/**
		 * The meta object literal for the '<em><b>Input</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference INTERNAL_INPUT__INPUT = eINSTANCE.getInternalInput_Input();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl <em>Server Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.ServerDescriptorImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getServerDescriptor()
		 * @generated
		 */
		EClass SERVER_DESCRIPTOR = eINSTANCE.getServerDescriptor();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__ID = eINSTANCE.getServerDescriptor_Id();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__NAME = eINSTANCE.getServerDescriptor_Name();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__DESCRIPTION = eINSTANCE.getServerDescriptor_Description();

		/**
		 * The meta object literal for the '<em><b>Contributor</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__CONTRIBUTOR = eINSTANCE.getServerDescriptor_Contributor();

		/**
		 * The meta object literal for the '<em><b>Clazz</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__CLAZZ = eINSTANCE.getServerDescriptor_Clazz();

		/**
		 * The meta object literal for the '<em><b>Icon16</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__ICON16 = eINSTANCE.getServerDescriptor_Icon16();

		/**
		 * The meta object literal for the '<em><b>Icon32</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__ICON32 = eINSTANCE.getServerDescriptor_Icon32();

		/**
		 * The meta object literal for the '<em><b>Connection</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__CONNECTION = eINSTANCE.getServerDescriptor_Connection();

		/**
		 * The meta object literal for the '<em><b>Configured</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__CONFIGURED = eINSTANCE.getServerDescriptor_Configured();

		/**
		 * The meta object literal for the '<em><b>Enabled</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__ENABLED = eINSTANCE.getServerDescriptor_Enabled();

		/**
		 * The meta object literal for the '<em><b>Configuration Element</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SERVER_DESCRIPTOR__CONFIGURATION_ELEMENT = eINSTANCE.getServerDescriptor_ConfigurationElement();

		/**
		 * The meta object literal for the '<em><b>Get Image16</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SERVER_DESCRIPTOR___GET_IMAGE16 = eINSTANCE.getServerDescriptor__GetImage16();

		/**
		 * The meta object literal for the '<em><b>Get Image32</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SERVER_DESCRIPTOR___GET_IMAGE32 = eINSTANCE.getServerDescriptor__GetImage32();

		/**
		 * The meta object literal for the '<em><b>Is Active</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation SERVER_DESCRIPTOR___IS_ACTIVE = eINSTANCE.getServerDescriptor__IsActive();

		/**
		 * The meta object literal for the '{@link org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl <em>Processor Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.ProcessorDescriptorImpl
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getProcessorDescriptor()
		 * @generated
		 */
		EClass PROCESSOR_DESCRIPTOR = eINSTANCE.getProcessorDescriptor();

		/**
		 * The meta object literal for the '<em><b>Processor</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__PROCESSOR = eINSTANCE.getProcessorDescriptor_Processor();

		/**
		 * The meta object literal for the '<em><b>Configuration Element</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__CONFIGURATION_ELEMENT = eINSTANCE.getProcessorDescriptor_ConfigurationElement();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__DESCRIPTION = eINSTANCE.getProcessorDescriptor_Description();

		/**
		 * The meta object literal for the '<em><b>Icon16</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__ICON16 = eINSTANCE.getProcessorDescriptor_Icon16();

		/**
		 * The meta object literal for the '<em><b>Contributor</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__CONTRIBUTOR = eINSTANCE.getProcessorDescriptor_Contributor();

		/**
		 * The meta object literal for the '<em><b>Directive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__DIRECTIVE = eINSTANCE.getProcessorDescriptor_Directive();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__NAME = eINSTANCE.getProcessorDescriptor_Name();

		/**
		 * The meta object literal for the '<em><b>Automatic</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_DESCRIPTOR__AUTOMATIC = eINSTANCE.getProcessorDescriptor_Automatic();

		/**
		 * The meta object literal for the '<em><b>Get Image16</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESSOR_DESCRIPTOR___GET_IMAGE16 = eINSTANCE.getProcessorDescriptor__GetImage16();

		/**
		 * The meta object literal for the '<em>Image</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.swt.graphics.Image
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getImage()
		 * @generated
		 */
		EDataType IMAGE = eINSTANCE.getImage();

		/**
		 * The meta object literal for the '<em>Dialog</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.jface.dialogs.Dialog
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getDialog()
		 * @generated
		 */
		EDataType DIALOG = eINSTANCE.getDialog();

		/**
		 * The meta object literal for the '<em>Report Processor Safe Wrapper</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper
		 * @see org.eclipse.epp.internal.logging.aeri.ide.impl.IdePackageImpl#getReportProcessorSafeWrapper()
		 * @generated
		 */
		EDataType REPORT_PROCESSOR_SAFE_WRAPPER = eINSTANCE.getReportProcessorSafeWrapper();

	}

} //IIdePackage
