/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.handlers;

import static org.eclipse.epp.logging.aeri.core.ResetSendMode.KEEP;
import static org.eclipse.epp.logging.aeri.core.SendMode.NOTIFY;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.SendMode;

public class ResetSendModeHandler {

    private boolean onFirstRun = true;

    @Execute
    public SendMode execute(ISystemSettings system) {
        switch (system.getResetSendMode()) {
        case KEEP:
        case PERMANENT:
            break;
        case RESTART:
            if (onFirstRun) {
                system.setSendMode(NOTIFY);
                system.setResetSendMode(KEEP);
                system.setResetSendModeOn(0);
                onFirstRun = false;
            }
            break;
        case HOURS_24:
            if (system.getResetSendModeOn() < System.currentTimeMillis()) {
                system.setSendMode(NOTIFY);
                system.setResetSendMode(KEEP);
                system.setResetSendModeOn(0);
            }
        }
        return system.getSendMode();
    }
}
