/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsAdditionalRendererService;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererService;

public class EMFFormsRendererFactoryImpl
implements EMFFormsRendererFactory {
    private final Set<EMFFormsRendererService<VElement>> rendererServices = new CopyOnWriteArraySet<EMFFormsRendererService<VElement>>();
    private final Set<EMFFormsAdditionalRendererService<VElement>> additionalRendererServices = new CopyOnWriteArraySet<EMFFormsAdditionalRendererService<VElement>>();

    public void addEMFFormsRendererService(EMFFormsRendererService<VElement> rendererService) {
        this.rendererServices.add(rendererService);
    }

    public void removeEMFFormsRendererService(EMFFormsRendererService<VElement> rendererService) {
        this.rendererServices.remove(rendererService);
    }

    protected void addEMFFormsAdditionalRendererService(EMFFormsAdditionalRendererService<VElement> rendererService) {
        this.additionalRendererServices.add(rendererService);
    }

    protected void removeEMFFormsAdditionalRendererService(EMFFormsAdditionalRendererService<VElement> rendererService) {
        this.additionalRendererServices.remove(rendererService);
    }

    @Override
    public <VELEMENT extends VElement> AbstractSWTRenderer<VElement> getRendererInstance(VELEMENT vElement, ViewModelContext viewModelContext) throws EMFFormsNoRendererException {
        if (this.rendererServices.isEmpty()) {
            throw new EMFFormsNoRendererException("No EMFFormsRendererService available!");
        }
        double highestPriority = -1.0;
        EMFFormsRendererService<VElement> bestService = null;
        for (EMFFormsRendererService<VElement> rendererService : this.rendererServices) {
            double priority = rendererService.isApplicable(vElement, viewModelContext);
            if (!(priority > highestPriority)) continue;
            highestPriority = priority;
            bestService = rendererService;
        }
        if (bestService == null) {
            throw new EMFFormsNoRendererException(String.format("No fitting EMFFormsRendererService for %1$s available!", vElement.eClass().getName()));
        }
        AbstractSWTRenderer<VElement> rendererInstance = bestService.getRendererInstance(vElement, viewModelContext);
        if (rendererInstance == null) {
            throw new EMFFormsNoRendererException(String.format("No fitting EMFFormsRendererService for %1$s available!", vElement.eClass().getName()));
        }
        try {
            rendererInstance.init();
        }
        catch (RuntimeException e) {
            throw new EMFFormsNoRendererException(e);
        }
        return rendererInstance;
    }

    public Collection<AbstractAdditionalSWTRenderer<VElement>> getAdditionalRendererInstances(VElement vElement, ViewModelContext viewModelContext) {
        LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>> renderers = new LinkedHashSet<AbstractAdditionalSWTRenderer<VElement>>();
        for (EMFFormsAdditionalRendererService<VElement> rendererService : this.additionalRendererServices) {
            if (!rendererService.isApplicable(vElement, viewModelContext)) continue;
            Collection<AbstractAdditionalSWTRenderer<VElement>> rendererInstances = rendererService.getRendererInstances(vElement, viewModelContext);
            for (AbstractAdditionalSWTRenderer<VElement> rendererInstance : rendererInstances) {
                rendererInstance.init();
                renderers.add(rendererInstance);
            }
        }
        return renderers;
    }

    public void clearRenderers() {
        this.rendererServices.clear();
    }
}

