/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.report;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.report.ReportServiceConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class ReportServiceImpl
implements ReportService {
    private final Set<ReportServiceConsumer> consumers = new LinkedHashSet<ReportServiceConsumer>();

    @Override
    public void report(AbstractReport reportEntity) {
        for (ReportServiceConsumer consumer : this.consumers) {
            consumer.reported(reportEntity);
        }
    }

    @Override
    @Deprecated
    public List<AbstractReport> getReports() {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public void clearReports() {
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addConsumer(ReportServiceConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(ReportServiceConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

