/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.action;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.common.ui.tools.api.selection.EObjectSelectionWizard;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenSelectModelElementAction
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> selections) {
        return true;
    }

    public void execute(Collection<? extends EObject> selections, final Map<String, Object> parameters) {
        Object messageObj = parameters.get("message");
        Object titleObj = parameters.get("title");
        Object candidates = parameters.get("candidates");
        final ArrayList toSelectFrom = Lists.newArrayList();
        if (candidates instanceof EObject) {
            toSelectFrom.add((EObject)candidates);
        } else if (candidates instanceof Iterable) {
            for (EObject eObject : Iterables.filter((Iterable)((Iterable)candidates), EObject.class)) {
                toSelectFrom.add(eObject);
            }
        }
        if (messageObj instanceof String) {
            final String message = (String)messageObj;
            final String title = this.getTitleFromParameter(titleObj);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    EObjectSelectionWizard wizard = new EObjectSelectionWizard(title, message, null, toSelectFrom, DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory());
                    wizard.setMany(false);
                    WizardDialog dlg = new WizardDialog(shell, (IWizard)wizard);
                    int result = dlg.open();
                    if (result == 0) {
                        Object featureObj = parameters.get("feature");
                        Object hostObj = parameters.get("host");
                        if (featureObj instanceof EStructuralFeature && hostObj instanceof EObject) {
                            ((EObject)hostObj).eSet((EStructuralFeature)featureObj, (Object)wizard.getSelectedEObject());
                        }
                    }
                }
            });
        }
    }

    private String getTitleFromParameter(Object titleObj) {
        String title = "Select Model Element";
        if (titleObj instanceof String) {
            title = (String)titleObj;
        }
        return title;
    }
}

