/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.generator;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xcore.generator.XcoreGenModelGeneratorAdapterFactory;
import org.eclipse.xtext.generator.IFileSystemAccess;

public class XcoreGeneratorImpl
extends Generator {
    @Inject
    private Provider<XcoreGenModelGeneratorAdapterFactory> adapterFactoryProvider;
    private IFileSystemAccess fsa;
    private String modelDirectory;

    public String getModelDirectory() {
        return this.modelDirectory;
    }

    public void setModelDirectory(String modelDirectory) {
        this.modelDirectory = modelDirectory;
    }

    public void setFileSystemAccess(IFileSystemAccess fsa) {
        this.fsa = fsa;
    }

    public void setInput(Object input) {
        if (input instanceof GenModel) {
            GenModel genModel = (GenModel)input;
            this.setModelDirectory(genModel.getModelDirectory());
        }
        super.setInput(input);
    }

    protected Collection<GeneratorAdapterFactory> getAdapterFactories(Object object) {
        List adapterFactories = (List)super.getAdapterFactories(object);
        if (adapterFactories.isEmpty()) {
            adapterFactories.add(this.createXcoreGeneratorAdapterFactory());
        } else {
            ListIterator<XcoreGenModelGeneratorAdapterFactory> i = adapterFactories.listIterator();
            while (i.hasNext()) {
                GeneratorAdapterFactory generatorAdapterFactory = (GeneratorAdapterFactory)i.next();
                if (generatorAdapterFactory.getClass() == GenModelGeneratorAdapterFactory.class) {
                    XcoreGenModelGeneratorAdapterFactory genAdapterFactory = this.createXcoreGeneratorAdapterFactory();
                    i.set(genAdapterFactory);
                    continue;
                }
                if (!(generatorAdapterFactory instanceof XcoreGenModelGeneratorAdapterFactory)) continue;
                XcoreGenModelGeneratorAdapterFactory xcoreGeneratorAdapterFactory = (XcoreGenModelGeneratorAdapterFactory)generatorAdapterFactory;
                xcoreGeneratorAdapterFactory.setGenerator(this);
                xcoreGeneratorAdapterFactory.setFileSystemAccess(this.fsa);
                xcoreGeneratorAdapterFactory.setModelDirectory(URI.createURI((String)this.modelDirectory));
            }
        }
        return adapterFactories;
    }

    protected XcoreGenModelGeneratorAdapterFactory createXcoreGeneratorAdapterFactory() {
        XcoreGenModelGeneratorAdapterFactory genAdapterFactory = (XcoreGenModelGeneratorAdapterFactory)((Object)this.adapterFactoryProvider.get());
        genAdapterFactory.setGenerator(this);
        genAdapterFactory.setFileSystemAccess(this.fsa);
        genAdapterFactory.setModelDirectory(URI.createURI((String)this.modelDirectory));
        return genAdapterFactory;
    }
}

