/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.eclipse.emf.compare.internal.dmp.LineBasedDiff;
import org.eclipse.emf.compare.internal.dmp.diff_match_patch;

public final class SimilarityComputer {
    public static final int MINIMUM_LENGTH = 1024;
    public static final double THRESHOLD = 0.3;

    private SimilarityComputer() {
    }

    public static boolean isSimilar(InputStream a, InputStream b) throws IOException {
        return SimilarityComputer.computeDifference(a, b) < 0.3;
    }

    public static double computeDifference(InputStream a, InputStream b) throws IOException {
        if (a == null || b == null) {
            return Double.MAX_VALUE;
        }
        try {
            LineFile fileA = SimilarityComputer.readUtf8(a);
            LineFile fileB = SimilarityComputer.readUtf8(b);
            double d = SimilarityComputer.internalCalculateSimilarity(fileA, fileB);
            return d;
        }
        finally {
            try {
                a.close();
            }
            catch (IOException iOException) {}
            try {
                b.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static double internalCalculateSimilarity(LineFile a, LineFile b) {
        if (a.characterCount < 1024L || b.characterCount < 1024L) {
            return Double.MAX_VALUE;
        }
        LineBasedDiff lineBasedDiff = new LineBasedDiff();
        long differences = 0L;
        LinkedList diffs = lineBasedDiff.diff_main(a.content, b.content, false);
        for (diff_match_patch.Diff diff : diffs) {
            if (diff.operation == diff_match_patch.Operation.EQUAL) continue;
            ++differences;
        }
        return (double)differences / (double)Math.max(a.lineCount, b.lineCount);
    }

    private static LineFile readUtf8(InputStream stream) throws IOException {
        String rd;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        LineFile result = new LineFile();
        while ((rd = reader.readLine()) != null) {
            builder.append(rd);
            builder.append('\n');
            ++result.lineCount;
            result.characterCount += (long)(rd.length() + 1);
        }
        result.content = builder.toString();
        return result;
    }

    private static class LineFile {
        long characterCount;
        long lineCount;
        String content;

        private LineFile() {
        }
    }
}

