/*
 * Copyright (c) 2010-2012, 2015, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.common.revision;

import org.eclipse.emf.cdo.common.branch.CDOBranch;

import java.util.List;
import java.util.Map;

/**
 * Provides consumers with all {@link CDORevision revisions} available in an instance of this interface.
 *
 * @author Eike Stepper
 * @since 3.0
 */
public interface CDOAllRevisionsProvider
{
  public Map<CDOBranch, List<CDORevision>> getAllRevisions();
}
