/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchDestinationPage;
import org.eclipse.egit.ui.internal.fetch.FetchSourcePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;

public class SimpleFetchRefSpecWizard
extends Wizard {
    private final FetchSourcePage sourcePage;
    private final FetchDestinationPage destinationPage;
    private RefSpec result;

    public SimpleFetchRefSpecWizard(Repository localRepository, RemoteConfig config) {
        this.sourcePage = new FetchSourcePage(localRepository, config);
        this.destinationPage = new FetchDestinationPage(localRepository, config);
        this.setWindowTitle(UIText.SimpleFetchRefSpecWizard_WizardTitle);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_FETCH);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.sourcePage);
        this.addPage((IWizardPage)this.destinationPage);
    }

    public boolean performFinish() {
        StringBuilder sb = new StringBuilder();
        if (this.destinationPage.isForce()) {
            sb.append('+');
        }
        sb.append(this.sourcePage.getSource());
        sb.append(':');
        sb.append(this.destinationPage.getDestination());
        this.result = new RefSpec(sb.toString());
        return true;
    }

    public RefSpec getSpec() {
        return this.result;
    }
}

