/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.transport.URIish;

public class SecureStoreUtils {
    public static boolean storeCredentials(UserPasswordCredentials credentials, URIish uri) {
        if (credentials != null && uri != null) {
            try {
                org.eclipse.egit.core.Activator.getDefault().getSecureStore().putCredentials(uri, credentials);
            }
            catch (StorageException e) {
                Activator.handleError(MessageFormat.format(UIText.SecureStoreUtils_writingCredentialsFailed, uri), e, true);
                return false;
            }
            catch (IOException e) {
                Activator.handleError(MessageFormat.format(UIText.SecureStoreUtils_writingCredentialsFailed, uri), e, true);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UserPasswordCredentials getCredentials(URIish uri) {
        try {
            return org.eclipse.egit.core.Activator.getDefault().getSecureStore().getCredentials(uri);
        }
        catch (StorageException e) {
            Activator.logError(MessageFormat.format(UIText.SecureStoreUtils_errorReadingCredentials, uri), e);
            SecureStoreUtils.clearCredentials(uri);
            return null;
        }
    }

    public static void clearCredentials(URIish uri) {
        try {
            org.eclipse.egit.core.Activator.getDefault().getSecureStore().clearCredentials(uri);
        }
        catch (IOException e) {
            Activator.logError(MessageFormat.format(UIText.SecureStoreUtils_errorClearingCredentials, uri), e);
        }
    }
}

