/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.internal.page.propertylist;

import org.eclipse.eef.properties.ui.internal.page.propertylist.EEFTabbedPropertyList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class EEFBottomNavigationElement
extends Canvas {
    private EEFTabbedPropertyList tabPropertyList;

    public EEFBottomNavigationElement(final EEFTabbedPropertyList tabbedPropertyList) {
        super((Composite)tabbedPropertyList, 524288);
        this.tabPropertyList = tabbedPropertyList;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EEFBottomNavigationElement.this.paint(e);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tabbedPropertyList.isDownScrollRequired()) {
                    tabbedPropertyList.setTopVisibleIndex(tabbedPropertyList.getTopVisibleIndex() + 1);
                    if (tabbedPropertyList.getBottomVisibleIndex() != tabbedPropertyList.getNumberOfElements() - 1) {
                        tabbedPropertyList.setBottomVisibleIndex(tabbedPropertyList.getBottomVisibleIndex() + 1);
                    }
                    tabbedPropertyList.layoutTabs();
                    tabbedPropertyList.getTopNavigationElement().redraw();
                    tabbedPropertyList.getBottomNavigationElement().redraw();
                }
            }
        });
    }

    protected void paint(PaintEvent e) {
        e.gc.setBackground(this.tabPropertyList.getColorHolder().getWidgetBackground());
        e.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetForeground());
        Rectangle bounds = this.getBounds();
        if (this.tabPropertyList.getNumberOfElements() != 0) {
            e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetNormalShadow());
            e.gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
            e.gc.drawLine(0, 0, bounds.width - 1, 0);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getBottomNavigationElementShadowStroke1());
            e.gc.drawLine(0, 1, bounds.width - 2, 1);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getBottomNavigationElementShadowStroke2());
            e.gc.drawLine(0, 2, bounds.width - 2, 2);
        } else {
            e.gc.setBackground(this.tabPropertyList.getColorHolder().getListBackground());
            e.gc.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        if (this.tabPropertyList.isDownScrollRequired()) {
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetDarkShadow());
            int middle = bounds.width / 2;
            int bottom = bounds.height - 3;
            e.gc.drawLine(middle + 1, bottom, middle + 5, bottom - 4);
            e.gc.drawLine(middle, bottom, middle - 4, bottom - 4);
            e.gc.drawLine(middle - 3, bottom - 4, middle + 4, bottom - 4);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getListBackground());
            e.gc.drawLine(middle, bottom - 1, middle + 1, bottom - 1);
            e.gc.drawLine(middle - 1, bottom - 2, middle + 2, bottom - 2);
            e.gc.drawLine(middle - 2, bottom - 3, middle + 3, bottom - 3);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getWidgetNormalShadow());
            e.gc.drawLine(0, bottom - 7, bounds.width - 2, bottom - 7);
            e.gc.setForeground(this.tabPropertyList.getColorHolder().getNavigationElementShadowStroke());
            e.gc.drawLine(0, bottom + 2, bounds.width - 2, bottom + 2);
            e.gc.drawLine(0, bottom - 6, bounds.width - 2, bottom - 6);
        }
    }
}

