/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core.launching;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.core.ICorePreferences;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.core.launching.ICoverageLaunch;
import org.eclipse.eclemma.internal.core.CoreMessages;
import org.eclipse.eclemma.internal.core.CoverageSession;
import org.eclipse.eclemma.internal.core.EclEmmaCorePlugin;
import org.eclipse.eclemma.internal.core.ExecutionDataFiles;
import org.eclipse.eclemma.internal.core.MemoryExecutionDataSource;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.runtime.RemoteControlReader;
import org.jacoco.core.runtime.RemoteControlWriter;

public class AgentServer
extends Job {
    private final ICoverageLaunch launch;
    private final ISessionManager sessionManager;
    private final ExecutionDataFiles files;
    private final ICorePreferences preferences;
    private ServerSocket serverSocket;
    private RemoteControlWriter writer;
    private boolean dataReceived;

    AgentServer(ICoverageLaunch launch, ISessionManager sessionManager, ExecutionDataFiles files, ICorePreferences preferences) {
        super(AgentServer.class.getName());
        this.preferences = preferences;
        this.setSystem(true);
        this.launch = launch;
        this.sessionManager = sessionManager;
        this.files = files;
        this.dataReceived = false;
    }

    public void start() throws CoreException {
        try {
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.AGENTSERVER_START_ERROR.getStatus(e));
        }
        this.schedule();
    }

    public void requestDump(boolean reset) throws CoreException {
        if (this.writer != null) {
            try {
                this.writer.visitDumpCommand(true, reset);
            }
            catch (IOException e) {
                throw new CoreException(EclEmmaStatus.DUMP_REQUEST_ERROR.getStatus(e));
            }
        }
    }

    public void stop() {
        this.writer = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            EclEmmaCorePlugin.getInstance().getLog().log(EclEmmaStatus.AGENTSERVER_STOP_ERROR.getStatus(e));
        }
        this.cancel();
    }

    public boolean hasDataReceived() {
        return this.dataReceived;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Socket socket = this.serverSocket.accept();
            this.writer = new RemoteControlWriter(socket.getOutputStream());
            RemoteControlReader reader = new RemoteControlReader(socket.getInputStream());
            while (true) {
                MemoryExecutionDataSource memory = new MemoryExecutionDataSource();
                memory.readFrom((ExecutionDataReader)reader);
                if (memory.isEmpty()) {
                    return Status.OK_STATUS;
                }
                this.dataReceived = true;
                CoverageSession session = new CoverageSession(this.createDescription(), this.launch.getScope(), this.files.newFile(memory), this.launch.getLaunchConfiguration());
                this.sessionManager.addSession(session, this.preferences.getActivateNewSessions(), this.launch);
            }
        }
        catch (IOException e) {
            return EclEmmaStatus.EXECDATA_DUMP_ERROR.getStatus(e);
        }
        catch (CoreException e) {
            return EclEmmaStatus.EXECDATA_DUMP_ERROR.getStatus(e);
        }
    }

    private String createDescription() {
        Object[] args = new Object[]{this.launch.getLaunchConfiguration().getName(), new Date()};
        return MessageFormat.format(CoreMessages.LaunchSessionDescription_value, args);
    }
}

