/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterEnvironmentVariablesBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterLibraryBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.internal.debug.ui.interpreters.ExpandableBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.IAddInterpreterDialogRequestor;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.InterpreterStandin;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclPackagesPackage;
import org.eclipse.dltk.tcl.core.packages.VariableMap;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.AvailablePackagesBlock;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.TclInterpreterEnvironmentVariablesBlock;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.TclInterpreterLibraryBlock;
import org.eclipse.dltk.tcl.internal.debug.ui.interpreters.TclInterpreterMessages;
import org.eclipse.dltk.tcl.internal.launching.StatusWithPackages;
import org.eclipse.dltk.tcl.internal.ui.GlobalVariableBlock;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.InterpreterDocumentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageLoader;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesFactory;
import org.eclipse.dltk.tcl.ui.manpages.ManpagesPackage;
import org.eclipse.dltk.tcl.ui.manpages.dialogs.ManPagesConfigurationDialog;
import org.eclipse.dltk.ui.dialogs.IStatusDialog;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AddTclInterpreterDialog
extends AddScriptInterpreterDialog {
    private GlobalVariableBlock globals;
    private AvailablePackagesBlock packagesBlock;
    private ExpandableBlock globalsExpandableNode;
    private ExpandableBlock libraryExpandableNode;
    private ExpandableBlock environmentExpandableNode;
    private ComboDialogField documentationField;
    private List<Documentation> documentations;

    public AddTclInterpreterDialog(IAddInterpreterDialogRequestor requestor, Shell shell, IInterpreterInstallType[] interpreterInstallTypes, IInterpreterInstall editedInterpreter) {
        super(requestor, shell, interpreterInstallTypes, editedInterpreter);
    }

    protected AbstractInterpreterLibraryBlock createLibraryBlock(AddScriptInterpreterDialog dialog) {
        return new TclInterpreterLibraryBlock(dialog);
    }

    protected AbstractInterpreterEnvironmentVariablesBlock createEnvironmentVariablesBlock() {
        return new TclInterpreterEnvironmentVariablesBlock(this);
    }

    protected Composite createEnvironmentVariablesBlockParent(Composite parent, int numColumns) {
        this.environmentExpandableNode = new ExpandableBlock(parent, 0);
        this.environmentExpandableNode.setText(InterpretersMessages.AddScriptInterpreterDialog_interpreterEnvironmentVariables);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.environmentExpandableNode.setLayoutData((Object)gd);
        this.environmentExpandableNode.setExpanded(true);
        return this.environmentExpandableNode.getContent();
    }

    protected Composite createLibraryBlockParent(Composite parent, int numColumns) {
        this.libraryExpandableNode = new ExpandableBlock(parent, 0);
        this.libraryExpandableNode.setText("Custom library locations (addition to TCLLIBPATH):");
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.libraryExpandableNode.setLayoutData((Object)gd);
        return this.libraryExpandableNode.getContent();
    }

    private Documentation findById(String docId) {
        if (docId != null) {
            for (Documentation documentation : this.documentations) {
                if (!docId.equals(documentation.getId())) continue;
                return documentation;
            }
        }
        return null;
    }

    protected void createSimpleFields(Composite parent, int numColumns) {
        super.createSimpleFields(parent, numColumns);
        this.documentationField = new ComboDialogField(2056);
        this.documentationField.setLabelText("Manual Pages");
        this.loadDocumentations();
        this.documentationField.doFillIntoGrid(parent, numColumns - 1);
        Button configureDocumentation = new Button(parent, 8);
        configureDocumentation.setText("Configure...");
        configureDocumentation.setLayoutData((Object)StringButtonDialogField.gridDataForButton((Button)configureDocumentation, (int)1));
        configureDocumentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTclInterpreterDialog.this.configureDocumentation();
            }
        });
    }

    protected void configureDocumentation() {
        ManPagesConfigurationDialog dialog = new ManPagesConfigurationDialog(this.getShell());
        if (dialog.open() == 0) {
            int index = this.documentationField.getSelectionIndex();
            String docId = index > 0 ? this.documentations.get(index - 1).getId() : null;
            this.loadDocumentations();
            Documentation doc = this.findById(docId);
            this.documentationField.selectItem(doc != null ? this.documentations.indexOf(doc) + 1 : 0);
        }
    }

    private void loadDocumentations() {
        this.documentations = new ArrayList<Documentation>(ManPageLoader.load().getDocumentations());
        String[] names = new String[this.documentations.size() + 1];
        names[0] = this.documentations.isEmpty() ? "(not configured)" : "(default)";
        Collections.sort(this.documentations, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        int i = 0;
        while (i < this.documentations.size()) {
            names[i + 1] = this.documentations.get(i).getName();
            ++i;
        }
        this.documentationField.setItems(names);
    }

    protected void createDialogBlocks(Composite parent, int numColumns) {
        super.createDialogBlocks(parent, numColumns);
        this.globalsExpandableNode = new ExpandableBlock(parent, 0);
        this.globalsExpandableNode.setText(TclInterpreterMessages.AddTclInterpreterDialog_0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.globalsExpandableNode.setLayoutData((Object)gd);
        this.globals = new GlobalVariableBlock((IStatusDialog)this);
        this.globals.createControlsIn(this.globalsExpandableNode.getContent());
        this.globalsExpandableNode.setExpanded(true);
        ExpandableBlock node2 = new ExpandableBlock(parent, 0);
        node2.setText("Available packages:");
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = numColumns;
        node2.setLayoutData((Object)gd2);
        this.packagesBlock = new AvailablePackagesBlock(this);
        this.packagesBlock.createIn(node2.getContent());
        node2.setExpanded(true);
    }

    protected void updateValidateInterpreterLocation() {
        super.updateValidateInterpreterLocation();
        IStatus status = this.getInterpreterLocationStatus();
        if (status instanceof StatusWithPackages) {
            StatusWithPackages swp = (StatusWithPackages)status;
            this.packagesBlock.updatePackages(swp.getInterpreter());
        } else {
            this.packagesBlock.updatePackages(null);
        }
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        Point size = shell.computeSize(-1, -1);
        Point size2 = shell.getSize();
        if (size.y > size2.y) {
            shell.setSize(size2.x, size.y);
        }
    }

    protected boolean useInterpreterArgs() {
        return false;
    }

    protected boolean isRediscoverSupported() {
        return false;
    }

    protected void okPressed() {
        super.okPressed();
        IInterpreterInstall install = this.getLastInterpreterInstall();
        if (install != null) {
            IContentCache coreCache = ModelManager.getModelManager().getCoreCache();
            coreCache.clearCacheEntryAttributes(install.getInstallLocation());
            TclPackagesManager.removeInterpreterInfo((IInterpreterInstall)install);
        }
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_TCL_SCRIPT_INTERPRETER_DIALOG_SECTION";
    }

    protected void initializeFields(IInterpreterInstall install) {
        super.initializeFields(install);
        if (install != null) {
            InterpreterDocumentation documentation = (InterpreterDocumentation)install.findExtension(ManpagesPackage.Literals.INTERPRETER_DOCUMENTATION);
            String docId = documentation != null ? documentation.getDocumentationId() : null;
            Documentation doc = this.findById(docId);
            this.documentationField.selectItem(doc != null ? this.documentations.indexOf(doc) + 1 : 0);
            VariableMap variableMap = (VariableMap)install.findExtension(TclPackagesPackage.Literals.VARIABLE_MAP);
            if (variableMap != null) {
                this.globals.setValues(variableMap.getVariables());
            } else {
                this.globals.setValues(ECollections.emptyEMap());
            }
        } else {
            this.documentationField.selectItem(0);
            this.globals.setValues(ECollections.emptyEMap());
        }
        this.globalsExpandableNode.setExpanded(!this.globals.getValues().isEmpty());
        this.environmentExpandableNode.setExpanded(this.fEnvironmentVariablesBlock.getEnvironmentVariables().length > 0);
    }

    protected void setFieldValuesToInterpreter(IInterpreterInstall install) {
        super.setFieldValuesToInterpreter(install);
        int index = this.documentationField.getSelectionIndex();
        if (index == 0) {
            install.replaceExtension(ManpagesPackage.Literals.INTERPRETER_DOCUMENTATION, null);
        } else {
            Documentation doc = this.documentations.get(index - 1);
            InterpreterDocumentation idoc = ManpagesFactory.eINSTANCE.createInterpreterDocumentation();
            idoc.setDocumentationId(doc.getId());
            install.replaceExtension(ManpagesPackage.Literals.INTERPRETER_DOCUMENTATION, (EObject)idoc);
        }
        EMap newVars = this.globals.getValues();
        EMap oldVars = TclPackagesManager.getVariablesEMap((IInterpreterInstall)install);
        if (!GlobalVariableBlock.equalsEMap((EMap)newVars, (EMap)oldVars)) {
            TclPackagesManager.setVariables((IInterpreterInstall)install, (EMap)newVars);
        }
    }

    public InterpreterStandin getInterpreterStandin() {
        InterpreterStandin standin = new InterpreterStandin(this.fSelectedInterpreterType, "$fake$");
        IEnvironment selectedEnv = this.getEnvironment();
        String locationName = this.getInterpreterPath();
        if (locationName.length() == 0) {
            Object file = null;
            return null;
        }
        IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)selectedEnv, (IPath)new Path(locationName));
        EnvironmentVariable[] environmentVariables = null;
        if (this.fEnvironmentVariablesBlock != null) {
            environmentVariables = this.fEnvironmentVariablesBlock.getEnvironmentVariables();
        }
        LibraryLocation[] locations = this.fLibraryBlock.getLibraryLocations();
        standin.setInstallLocation(file);
        standin.setLibraryLocations(locations);
        standin.setEnvironmentVariables(environmentVariables);
        return standin;
    }
}

