/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PackageElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceElement;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.swt.graphics.Image;

public class InstrumentationLabelProvider
extends AppearanceAwareLabelProvider {
    protected InstrumentationContentProvider fContentProvider;
    private boolean fIsFlatLayout = false;

    public InstrumentationLabelProvider(InstrumentationContentProvider cp) {
        super(0x201200000002BL | ScriptElementLabels.ALL_CATEGORY, 3, TclUI.getDefault().getPreferenceStore());
        Assert.isNotNull((Object)((Object)cp));
        this.fContentProvider = cp;
    }

    private String getSpecificText(Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).packageName;
        }
        if (element instanceof SourceElement) {
            return ((SourceElement)element).path.toString();
        }
        if (!this.fIsFlatLayout && element instanceof IScriptFolder) {
            IScriptFolder fragment = (IScriptFolder)element;
            Object parent = this.fContentProvider.getHierarchicalPackageParent(fragment);
            if (parent instanceof IScriptFolder) {
                return this.getNameDelta((IScriptFolder)parent, fragment);
            }
            if (parent instanceof IFolder) {
                return this.getNameDelta((IFolder)parent, fragment);
            }
        }
        return null;
    }

    public String getText(Object element) {
        String text = this.getSpecificText(element);
        if (text != null) {
            return this.decorateText(text, element);
        }
        return super.getText(element);
    }

    private String getNameDelta(IScriptFolder parent, IScriptFolder fragment) {
        String prefix = String.valueOf(parent.getElementName()) + '/';
        String fullName = fragment.getElementName();
        if (fullName.startsWith(prefix)) {
            return fullName.substring(prefix.length());
        }
        return fullName;
    }

    private String getNameDelta(IFolder parent, IScriptFolder fragment) {
        IPath fullPath;
        IPath prefix = parent.getFullPath();
        if (prefix.isPrefixOf(fullPath = fragment.getPath())) {
            StringBuffer buf = new StringBuffer();
            int i = prefix.segmentCount();
            while (i < fullPath.segmentCount()) {
                if (buf.length() > 0) {
                    buf.append('/');
                }
                buf.append(fullPath.segment(i));
                ++i;
            }
            return buf.toString();
        }
        return fragment.getElementName();
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    public Image getImage(Object element) {
        if (element instanceof PackageElement) {
            return DLTKUIPlugin.getImageDescriptorRegistry().get(DLTKPluginImages.DESC_OBJS_PACKAGE);
        }
        if (element instanceof SourceElement) {
            return DLTKUIPlugin.getImageDescriptorRegistry().get(DLTKPluginImages.DESC_OBJS_CUNIT);
        }
        return super.getImage(element);
    }
}

