/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.util;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void log(Throwable t, String message) {
        SqlscrapbookPlugin.log((IStatus)new Status(4, SqlscrapbookPlugin.getPluginId(), 1, message, t));
    }

    public static void handle(CoreException e, String title, String message) {
        ExceptionHandler.handle(e, SqlscrapbookPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, String title, String message) {
        ExceptionHandler.handle(e, SqlscrapbookPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        SqlscrapbookPlugin.log(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            SqlscrapbookPlugin.log(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(SqlscrapbookPlugin.getResourceString("ExceptionDialog.seeErrorLogMessage"));
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

