/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import java.util.Observable;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OmitSchemaChangedNotifier
extends Observable {
    private static OmitSchemaChangedNotifier myself;
    protected boolean omitSchema;

    private OmitSchemaChangedNotifier() {
        SQLBuilderPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("omit.current.schema.in.sql")) {
                    OmitSchemaChangedNotifier.this.schemaChanged(null, SQLBuilderPlugin.getPlugin().getPreferenceStore().getBoolean("omit.current.schema.in.sql"));
                }
            }
        });
    }

    public static OmitSchemaChangedNotifier getInstance() {
        if (myself == null) {
            myself = new OmitSchemaChangedNotifier();
        }
        return myself;
    }

    public boolean isOmitSchema() {
        return this.omitSchema;
    }

    public void setOmitSchema(boolean omit) {
        this.omitSchema = omit;
    }

    public void schemaChanged(Object schema, boolean omit) {
        this.setOmitSchema(omit);
        this.setChanged();
        this.notifyObservers(schema);
    }
}

