/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ISQLDialectInfo;

public class SQLDialectInfo
implements ISQLDialectInfo {
    protected String _product = null;
    protected String _version = null;
    protected String _omitSchema = null;

    public SQLDialectInfo(String product, String version, String omitSchema) {
        this._product = product;
        this._version = version;
        this._omitSchema = omitSchema;
    }

    public SQLDialectInfo() {
        this(null, null, null);
    }

    @Override
    public String getProduct() {
        return this._product;
    }

    @Override
    public void setProduct(String product) {
        this._product = product;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public String getOmitSchema() {
        return this._omitSchema;
    }

    @Override
    public void setOmitSchema(String omitSchema) {
        this._omitSchema = omitSchema;
    }

    @Override
    public String encode() {
        StringBuffer code = new StringBuffer("");
        if (this._product != null) {
            code.append(this._product);
        }
        code.append(":");
        if (this._version != null) {
            code.append(this._version);
        }
        code.append(":");
        if (this._omitSchema != null) {
            code.append(this._omitSchema);
        }
        return code.toString();
    }

    public static SQLDialectInfo decode(String code) {
        SQLDialectInfo sqlDialectInfo = new SQLDialectInfo();
        if (code == null || !code.matches(".*:.*:.*")) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTrace("Cannot decode SQLDialectInfo <" + code + ">");
        } else {
            int i = 0;
            int j = code.indexOf(58);
            if (j > i) {
                String sProduct;
                sqlDialectInfo._product = sProduct = code.substring(i, j);
            }
            if ((j = code.indexOf(58, i = j + 1)) > i) {
                String sVersion;
                sqlDialectInfo._version = sVersion = code.substring(i, j);
            }
            if ((i = j + 1) < code.length()) {
                String sOmitSchema;
                sqlDialectInfo._omitSchema = sOmitSchema = code.substring(i);
            }
        }
        return sqlDialectInfo;
    }
}

