/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.util;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;

public class RoutineUtil {
    public static String constructCallableSPUDFString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("{?=");
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
        String procName = null;
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
            procName = proc.getProcName();
        }
        if (pds != null && pds.length > 0) {
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            int i = 0;
            while (i < pds.length) {
                String name = pds[i].getName();
                if (!(pds[i].getParmType() != 1 && pds[i].getParmType() != 2 && pds[i].getParmType() != 4 && pds[i].getParmType() != 0 || name.equals(procName))) {
                    if (j != 0) {
                        buffer.append(",?");
                    } else {
                        buffer.append("?");
                    }
                    ++j;
                }
                ++i;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        } else {
            buffer.append("()");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static String constructCallableSPUDFDisplayString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer;
        block10: {
            buffer = new StringBuffer(20);
            int type = proc == null ? 0 : proc.getType();
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
            buffer.append(config.getExecutionService().getCallableStatementPrefix(proc.getType()));
            String LINESEPARATOR = System.getProperty("line.separator");
            String procName = null;
            if (proc != null) {
                buffer.append(proc.getCallableString(quoted_id));
                procName = proc.getProcName();
            }
            if (pds == null || pds.length <= 0) break block10;
            if (type == 1 || type == 0) {
                buffer.append("(");
            }
            int j = 0;
            int k = 0;
            int i = 0;
            while (i < pds.length) {
                block12: {
                    String prefix;
                    String name;
                    block11: {
                        name = pds[i].getName();
                        prefix = "";
                        if (pds[i].getParmType() != 1 && pds[i].getParmType() != 2) break block11;
                        String value = null;
                        if (values != null && values.size() >= k + 1) {
                            value = (String)values.get(k++);
                        }
                        if (name.equals(procName)) break block12;
                        if (value != null && pds[i].isStringType() && SQLUtil.findQuotes((String)value) == 0) {
                            value = SQLUtil.quote((String)value, (char)'\'');
                        }
                        prefix = j != 0 ? "," : "";
                        buffer.append(String.valueOf(prefix) + LINESEPARATOR + "     " + pds[i].getName() + "=" + value + " " + pds[i].getTypeName() + " " + pds[i].getParamTypeAsString());
                        ++j;
                    }
                    if (!(pds[i].getParmType() != 4 && pds[i].getParmType() != 0 || name.equals(procName))) {
                        String paramType = "OUT";
                        prefix = j != 0 ? "," : "";
                        buffer.append(String.valueOf(prefix) + LINESEPARATOR + "     " + pds[i].getName() + " " + pds[i].getTypeName() + " " + paramType);
                        ++j;
                    }
                }
                ++i;
            }
            if (type == 1 || type == 0) {
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    public static String constructSPUDFDirectInvocationString(ProcIdentifier proc, List values, ParameterDescriptor[] pds, boolean quoted_id) {
        StringBuffer buffer = new StringBuffer(20);
        int type = proc == null ? 0 : proc.getType();
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)proc.getDatabaseIdentifier().getProfileName());
        buffer.append(config.getExecutionService().getDirectInvocationPrefix(proc.getType()));
        if (proc != null) {
            buffer.append(proc.getCallableString(quoted_id));
        }
        buffer.append(" ");
        if (type == 1) {
            buffer.append("(");
        }
        if (pds != null && pds.length > 0) {
            int i = 0;
            while (i < pds.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (values == null || values.size() <= i || values.get(i) == null) {
                    buffer.append("null");
                } else if (pds[i].isStringType() && SQLUtil.findQuotes((String)values.get(i).toString()) == 0) {
                    buffer.append(SQLUtil.quote((String)((String)values.get(i)), (char)'\''));
                } else {
                    buffer.append(values.get(i));
                }
                ++i;
            }
        }
        if (type == 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static String constructTriggerEventString(ProcIdentifier proc, Map values, boolean quoted_id) {
        StringBuffer sb = new StringBuffer("TRIGGER EVENT ");
        if (proc != null) {
            if (quoted_id) {
                String quotedName = SQLDevToolsUtil.quoteWhenNecessary((String)proc.getProcName(), (DatabaseIdentifier)proc.getDatabaseIdentifier(), (String)"\"", (int)9);
                sb.append(quotedName);
            } else {
                sb.append(proc.getProcName());
            }
        }
        if (values != null && values.size() > 0) {
            sb.append("(");
            for (String name : values.keySet()) {
                String value = (String)values.get(name);
                String quotedName = SQLDevToolsUtil.quoteWhenNecessary((String)name, (DatabaseIdentifier)proc.getDatabaseIdentifier(), (String)"\"", (int)11);
                sb.append(quotedName).append("=").append(SQLUtil.quote((String)value, (char)'\'')).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
        }
        return sb.toString();
    }

    public static boolean equals(int parserType, int procType, String objstr, String defDB, String defOwner, ProcIdentifier proc, boolean caseSensitive) {
        String objname;
        if (!RoutineUtil.isSameType(parserType, procType)) {
            return false;
        }
        String[] tokens = SQLUtil.parseDatabaseObject((String)objstr);
        int count = tokens.length;
        if (count == 0 || count > 3) {
            return false;
        }
        if (parserType == 160 || parserType == 60) {
            defOwner = proc.getOwnerName();
        }
        String db = count == 3 ? tokens[2] : defDB;
        String owner = count >= 2 ? tokens[1] : proc.getOwnerName();
        String string = objname = count >= 1 ? tokens[0] : objstr;
        return SQLUtil.equalsIgnoreQuote((String)proc.getDatabaseIdentifier().getDBname(), (String)db, (boolean)caseSensitive) && SQLUtil.equalsIgnoreQuote((String)proc.getOwnerName(), (String)owner, (boolean)caseSensitive) && SQLUtil.equalsIgnoreQuote((String)proc.getProcName(), (String)objname, (boolean)caseSensitive);
    }

    public static boolean isSameType(int parserType, int procType) {
        boolean same = (parserType == 158 || parserType == 58) && procType == 0;
        same = same || (parserType == 159 || parserType == 59) && procType == 1;
        same = same || (parserType == 160 || parserType == 60) && procType == 2;
        same = same || (parserType == 161 || parserType == 61) && procType == 3;
        return same;
    }
}

