/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.export;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.internal.export.OutputterUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class XMLOutputter
extends AbstractOutputter {
    private static ILogger _log = ResultsViewUIPlugin.getLogger(null);
    private static final String XMLNS_XSI = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static final String RESULT_TAG = "resultsetoutputter.resultTag";
    private static final String ROW_TAG = "resultsetoutputter.rowTag";

    public void output(IResultSetObject resultset, Properties options, OutputStream stream) throws IOException {
        String encoding = options.getProperty("encoding");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, encoding));
        this.output(resultset, options, writer);
    }

    public void output(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        this.outputXMLHeader(options, writer);
        this.outputXMLContent(resultset, options, writer);
        this.outputXMLFooter(options, writer);
    }

    public void output(IResultInstance rs, Properties props, OutputStream os) throws IOException {
        String encoding = props.getProperty("encoding");
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, encoding));
        this.output(rs, props, writer);
    }

    public void output(IResultInstance rs, Properties props, PrintWriter pw) throws IOException {
        this.outputXMLHeader(props, pw);
        int i = 0;
        while (i < rs.getItemCount()) {
            ResultItem item = rs.getItem(i);
            if (item != null && item.getResultObject() instanceof IResultSetObject) {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                this.outputXMLContent(result, props, pw);
            }
            ++i;
        }
        this.outputXMLFooter(props, pw);
    }

    private void outputXMLHeader(Properties options, PrintWriter writer) {
        String rootTag = ResultsViewUIPlugin.getDefault().getPreferenceStore().getString(PreferenceConstants.EXPORT_FORMAT_XML_ROOT_TAG);
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        boolean addHeader = store.getBoolean(PreferenceConstants.EXPORT_FORMAT_ADD_XML_HEADER);
        boolean addRootTag = store.getBoolean(PreferenceConstants.EXPORT_FORMAT_ADD_XML_ROOT_TAG);
        if (addHeader) {
            this.outputXMLRealHeader(options, writer);
        }
        if (addRootTag) {
            writer.println("<" + rootTag + ">");
        }
    }

    private void outputXMLContentColumn(Object[] rowdata, String[] columnNames, Properties options, PrintWriter writer) throws IOException {
        String rowTag = options.getProperty(ROW_TAG, "row");
        writer.println("    <" + rowTag + ">");
        int j = 0;
        while (j < rowdata.length) {
            writer.write("        <column name=\"" + columnNames[j] + "\"");
            if (rowdata[j] == null) {
                writer.write(" null=\"true\">");
            } else {
                writer.write(">");
                if (rowdata[j] instanceof byte[]) {
                    OutputterUtil.writeBinaryData(writer, rowdata[j]);
                } else {
                    OutputterUtil.writeStringData(writer, rowdata[j].toString());
                }
            }
            writer.println("</column>");
            ++j;
        }
        writer.println("    </" + rowTag + ">");
        writer.flush();
    }

    private void outputXMLContent(IResultSetObject resultset, Properties options, PrintWriter writer) throws IOException {
        String resultTag = options.getProperty(RESULT_TAG, "resultset");
        Iterator iter = resultset.getAllRecords();
        writer.println("<" + resultTag + XMLNS_XSI);
        writer.flush();
        if (resultset instanceof XMLResultSetObject) {
            if (iter != null && iter.hasNext()) {
                IResultSetRow data = (IResultSetRow)iter.next();
                String s1 = data.getData(0).toString();
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    builder.parse(new ByteArrayInputStream(s1.getBytes()));
                    writer.println(s1);
                    writer.flush();
                }
                catch (Exception dex) {
                    _log.error("ResultsViewAPI_notwellformed_xml", (Throwable)dex);
                }
            }
        } else {
            String[] columnNames = resultset.getColumnNames();
            int i = 0;
            while (i < columnNames.length) {
                columnNames[i] = OutputterUtil.escapeForXML(columnNames[i]);
                ++i;
            }
            while (iter != null && iter.hasNext()) {
                IResultSetRow data = (IResultSetRow)iter.next();
                this.outputXMLContentColumn(data.getData(), columnNames, options, writer);
            }
            iter = null;
        }
        writer.println("</" + resultTag + ">");
        writer.flush();
    }

    private void outputXMLRealHeader(Properties options, PrintWriter writer) {
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        String prefEncoding = store.getString(PreferenceConstants.EXPORT_FORMAT_PREF_ENCODING);
        if (prefEncoding.equals(options.getProperty("encoding"))) {
            writer.println(store.getString(PreferenceConstants.EXPORT_FORMAT_XML_HEADER));
        } else {
            String xmlHeaderFormat = Messages.ExportFormatPage_xmlexportformat_xmlheader_text;
            String xmlHeader = NLS.bind((String)xmlHeaderFormat, (Object[])new String[]{options.getProperty("encoding")});
            writer.println(xmlHeader);
        }
    }

    private void outputXMLFooter(Properties options, PrintWriter writer) {
        String rootTag = ResultsViewUIPlugin.getDefault().getPreferenceStore().getString(PreferenceConstants.EXPORT_FORMAT_XML_ROOT_TAG);
        boolean addRootTag = ResultsViewUIPlugin.getDefault().getPreferenceStore().getBoolean(PreferenceConstants.EXPORT_FORMAT_ADD_XML_ROOT_TAG);
        if (addRootTag) {
            writer.println("</" + rootTag + ">");
            writer.flush();
        }
    }

    public void output(IResultSetObject rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }

    public void output(IResultInstance rs, Properties props, String path) throws IOException {
        PrintWriter writer = this.createPrintWriter(path, props.getProperty("encoding"));
        this.output(rs, props, writer);
        writer.close();
    }
}

