/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui.extract;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.DataCorePlugin;
import org.eclipse.datatools.sqltools.data.internal.core.common.Output;
import org.eclipse.datatools.sqltools.data.internal.core.extract.ExtractData;
import org.eclipse.datatools.sqltools.data.internal.ui.FileFormatWizardPage;
import org.eclipse.datatools.sqltools.data.internal.ui.OutputItemAdapter;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.ExtractDataWizardPage;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.IExternalExtract;
import org.eclipse.datatools.sqltools.data.internal.ui.extract.Messages;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ExtractDataWizard
extends Wizard {
    protected Table table;
    protected FileFormatWizardPage page;
    private String EXTERNAL_EXTRACT_EXT_POINT = "org.eclipse.datatools.sqltools.data.ui.externalTableDataExtract";
    private String EXTERNAL_EXTRACT_EXT_POINT_VENDOR = "vendor";
    private String EXTERNAL_EXTRACT_EXT_POINT_VERSION = "version";
    private String EXTERNAL_EXTRACT_EXT_POINT_CLASS = "class";

    public ExtractDataWizard(Table table) {
        this.table = table;
        this.setWindowTitle(Messages.getString("ExtractDataWizard.ExtractData"));
    }

    public void addPages() {
        this.page = new ExtractDataWizardPage("org.eclipse.wst.rdb.data.ui.extractData");
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveSettings();
        String colDelim = this.page.getColumnDelimiter();
        String stringDelim = this.page.getStringDelimiter();
        String filePath = this.page.getFilePath();
        final OperationCommand item = this.initDbOutputItem();
        Connection conn = ((ICatalogObject)this.table).getConnection();
        final IExternalExtract externalExtract = (IExternalExtract)this.getExternalExtract(conn);
        if (externalExtract != null && externalExtract.isUseExternalExtract()) {
            externalExtract.setDelimiters(colDelim, stringDelim);
            externalExtract.setFilePath(filePath);
            externalExtract.setTable(this.table);
            Job job = new Job(Messages.getString("ExtractDataWizard.DataExtraction")){

                protected IStatus run(IProgressMonitor monitor) {
                    int ret = externalExtract.doExtract(new OutputItemAdapter(item));
                    ResultsViewAPI.getInstance().updateStatus(item, ret);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.schedule();
        } else {
            final ExtractData extract = new ExtractData(this.table, filePath);
            extract.setDelims(colDelim, stringDelim);
            Job job = new Job(Messages.getString("ExtractDataWizard.DataExtraction")){

                protected IStatus run(IProgressMonitor monitor) {
                    int ret = extract.doExtract((Output)new OutputItemAdapter(item));
                    ResultsViewAPI.getInstance().updateStatus(item, ret);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.schedule();
        }
        return true;
    }

    protected OperationCommand initDbOutputItem() {
        String qualifiedTableName = DataCorePlugin.getQualifiedTableName((Table)this.table);
        int actionType = 10;
        String displayStr = qualifiedTableName;
        String consumerName = null;
        Database database = this.table.getSchema().getCatalog() != null ? this.table.getSchema().getCatalog().getDatabase() : this.table.getSchema().getDatabase();
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)database);
        String connectionProfieName = ((ConnectionInfoImpl)connInfo).getConnectionProfile().getName();
        String databaseName = database.getName();
        OperationCommand oCommand = new OperationCommand(actionType, displayStr, consumerName, connectionProfieName, databaseName);
        return oCommand;
    }

    protected String getFullyQualifiedName() {
        return "\"" + this.table.getSchema().getName() + "\".\"" + this.table.getName() + "\"";
    }

    private Object getExternalExtract(Connection conn) {
        Object externalExecutable = null;
        Database db = this.table.getSchema().getCatalog() != null ? this.table.getSchema().getCatalog().getDatabase() : this.table.getSchema().getDatabase();
        String thisVendor = db.getVendor();
        if (conn != null) {
            try {
                int thisMajorVersion = conn.getMetaData().getDatabaseMajorVersion();
                int thisMinorVersion = conn.getMetaData().getDatabaseMinorVersion();
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(this.EXTERNAL_EXTRACT_EXT_POINT);
                IExtension[] extensions = extensionPoint.getExtensions();
                int numExt = 0;
                while (numExt < extensions.length) {
                    IExtension ext = extensions[numExt];
                    IConfigurationElement[] configElements = ext.getConfigurationElements();
                    int config = 0;
                    while (config < configElements.length) {
                        String extensionVersion;
                        float ver;
                        String extensionVendor = configElements[config].getAttribute(this.EXTERNAL_EXTRACT_EXT_POINT_VENDOR);
                        if (thisVendor.equalsIgnoreCase(extensionVendor) && (double)thisMajorVersion + (double)thisMinorVersion * 0.1 >= (double)(ver = Float.parseFloat(extensionVersion = configElements[config].getAttribute(this.EXTERNAL_EXTRACT_EXT_POINT_VERSION)))) {
                            externalExecutable = configElements[config].createExecutableExtension(this.EXTERNAL_EXTRACT_EXT_POINT_CLASS);
                        }
                        ++config;
                    }
                    ++numExt;
                }
            }
            catch (SQLException sQLException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (CoreException coreException) {}
        }
        return externalExecutable;
    }
}

