/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class QueryCombinedOperator
extends AbstractEnumerator {
    public static final int UNION = 0;
    public static final int UNION_ALL = 1;
    public static final int INTERSECT = 2;
    public static final int INTERSECT_ALL = 3;
    public static final int EXCEPT = 4;
    public static final int EXCEPT_ALL = 5;
    public static final QueryCombinedOperator UNION_LITERAL = new QueryCombinedOperator(0, "UNION", "UNION");
    public static final QueryCombinedOperator UNION_ALL_LITERAL = new QueryCombinedOperator(1, "UNION_ALL", "UNION_ALL");
    public static final QueryCombinedOperator INTERSECT_LITERAL = new QueryCombinedOperator(2, "INTERSECT", "INTERSECT");
    public static final QueryCombinedOperator INTERSECT_ALL_LITERAL = new QueryCombinedOperator(3, "INTERSECT_ALL", "INTERSECT_ALL");
    public static final QueryCombinedOperator EXCEPT_LITERAL = new QueryCombinedOperator(4, "EXCEPT", "EXCEPT");
    public static final QueryCombinedOperator EXCEPT_ALL_LITERAL = new QueryCombinedOperator(5, "EXCEPT_ALL", "EXCEPT_ALL");
    private static final QueryCombinedOperator[] VALUES_ARRAY = new QueryCombinedOperator[]{UNION_LITERAL, UNION_ALL_LITERAL, INTERSECT_LITERAL, INTERSECT_ALL_LITERAL, EXCEPT_LITERAL, EXCEPT_ALL_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static QueryCombinedOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueryCombinedOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueryCombinedOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QueryCombinedOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QueryCombinedOperator get(int value) {
        switch (value) {
            case 0: {
                return UNION_LITERAL;
            }
            case 1: {
                return UNION_ALL_LITERAL;
            }
            case 2: {
                return INTERSECT_LITERAL;
            }
            case 3: {
                return INTERSECT_ALL_LITERAL;
            }
            case 4: {
                return EXCEPT_LITERAL;
            }
            case 5: {
                return EXCEPT_ALL_LITERAL;
            }
        }
        return null;
    }

    private QueryCombinedOperator(int value, String name, String literal) {
        super(value, name, literal);
    }
}

