/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.enablement.sybase.util.SystemTableParameters;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;

public class ShowSysTableUtil {
    public static String KEY_NAME = "SHOW_SYS_TABLES_MAP";
    private static Map showSysTableMap = null;

    public static String getKey(Schema schema) {
        StringBuffer sb = new StringBuffer("");
        Catalog clg = schema.getCatalog();
        IConnectionProfile connProfile = ModelUtil.getConnectionProfile((Database)clg.getDatabase());
        sb.append(ShowSysTableUtil.getKeyPrefix(connProfile.getName())).append("DATABASE_").append(clg.getName()).append("_").append("SCHEMA_").append(schema.getName());
        return sb.toString();
    }

    public static String getKeyPrefix(String profileName) {
        return "PROFILE_" + profileName.hashCode() + "_";
    }

    private static void setShowSysTableMap(Map map) {
        SystemTableParameters.getInstance().setMap(map);
    }

    public static Map getShowSysTableMap() {
        showSysTableMap = SystemTableParameters.getInstance().getMap();
        return showSysTableMap;
    }

    public static boolean isShowSysTableOn(Schema schema) {
        Map map = ShowSysTableUtil.getShowSysTableMap();
        Boolean b = (Boolean)map.get(ShowSysTableUtil.getKey(schema));
        if (b == null) {
            return false;
        }
        return b;
    }

    public static void removeShowSysTableMapEntry(String profileName) {
        HashMap newMap = new HashMap();
        Map map = ShowSysTableUtil.getShowSysTableMap();
        for (String key : map.keySet()) {
            if (key.startsWith(ShowSysTableUtil.getKeyPrefix(profileName))) continue;
            newMap.put(key, map.get(key));
        }
        ShowSysTableUtil.setShowSysTableMap(newMap);
    }

    public static void changeShowSysTableMapEntry(String profileName, String oldName) {
        HashMap newMap = new HashMap();
        Map map = ShowSysTableUtil.getShowSysTableMap();
        for (String key : map.keySet()) {
            String prefix;
            if (key.startsWith(prefix = ShowSysTableUtil.getKeyPrefix(oldName))) {
                String postfix = key.substring(prefix.length());
                newMap.put(String.valueOf(ShowSysTableUtil.getKeyPrefix(profileName)) + postfix, map.get(key));
                continue;
            }
            newMap.put(key, map.get(key));
        }
        ShowSysTableUtil.setShowSysTableMap(newMap);
    }
}

