/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.internal.connection;

import java.sql.Driver;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.generic.JDBCConnection;

public class JDBCASAJDBCConnection
extends JDBCConnection {
    public JDBCASAJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    protected Object createConnection(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        String uid = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String pwd = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        String nameValuePairs = props.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        String propDelim = ",";
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, ",");
            String addPairs = "";
            int i = 0;
            while (i < pairs.length) {
                String[] namevalue = this.parseString(pairs[i], "=");
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = String.valueOf(addPairs) + propDelim;
                }
                addPairs = String.valueOf(addPairs) + pairs[i];
                ++i;
            }
        }
        String name = InternalNameGenerator.getName();
        connectionProps.put("REMOTEPWD", ",,CON=" + name);
        Driver jdbcDriver = (Driver)cl.loadClass(driverClass).newInstance();
        return jdbcDriver.connect(connectURL, connectionProps);
    }

    public static class InternalNameGenerator {
        private static int _sequence;
        public static final String PREFIX = "__dmpinternalname_";

        public static synchronized String getName() {
            return PREFIX + _sequence++;
        }
    }
}

