/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.ConstraintDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ASATableCheckConstraintDeltaDdlGenProvider
extends ConstraintDeltaDdlGenProvider {
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        super.getModificationResult(e, feature, oldValue, newValue, quoteIdentifiers, qualifyNames, fullSyntax, script);
        if (!(e instanceof CheckConstraint)) {
            return;
        }
        CheckConstraint rc = (CheckConstraint)e;
        if (feature.getFeatureID() == 8) {
            String tableName = rc.getBaseTable().getName();
            String constraintName = rc.getName();
            if (quoteIdentifiers) {
                tableName = SQLUtil.quote((String)tableName, (String)"\"");
                constraintName = SQLUtil.quote((String)constraintName, (String)"\"");
            }
            StringBuffer statement = new StringBuffer(128);
            statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)rc.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ").append("ALTER").append(" ").append("CONSTRAINT").append(" ").append(constraintName).append(" ").append("CHECK").append("(").append(rc.getSearchCondition().getSQL()).append(")");
            script.addAlterTableAlterConstraintStatements(statement.toString());
        }
    }

    protected void reCreateConstraint(DDLGenerator ddlgen, CheckConstraint rc, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        String newName = rc.getName();
        if (this.isNameChanged((SQLObject)rc)) {
            rc.setName(this.getOldName((SQLObject)rc));
        }
        String[] ddl = ddlgen.dropSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
        int i = 0;
        while (i < ddl.length) {
            script.addAlterTableDropConstraintStatement(ddl[i]);
            ++i;
        }
        rc.setName(newName);
        ddl = ddlgen.createSQLObjects(new SQLObject[]{rc}, quoteIdentifiers, qualifyNames, null);
        i = 0;
        while (i < ddl.length) {
            script.addAlterTableAddConstraintStatement(ddl[i]);
            ++i;
        }
    }

    protected boolean needGenerateRenamingDdl(Constraint constraint) {
        if (!(constraint instanceof CheckConstraint)) {
            return true;
        }
        CheckConstraint rc = (CheckConstraint)constraint;
        List list = (List)this._modifyRecordMap.get(rc);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 8) {
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isNameChanged(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String getOldName(SQLObject obj) {
        List list = (List)this._modifyRecordMap.get(obj);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord cr = (SybaseDeltaDdlGeneration.FeatureChangeRecord)list.get(i);
                if (cr.feature.getFeatureID() == 1) {
                    return (String)cr.oldValue;
                }
                ++i;
            }
        }
        return obj.getName();
    }

    protected String[] generateRenameConstraintStatement(Constraint constraint, String oldname, String newname, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer("");
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.eContainer(), quoteIdentifiers, qualifyNames)).append(" ").append("RENAME").append(" ").append("CONSTRAINT").append(" ").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(oldname) : oldname).append(" ").append("TO").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(newname) : newname);
        return new String[]{sb.toString()};
    }
}

