/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.postgresql.catalog;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCSchema;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.postgresql.catalog.loaders.PostgresSequenceLoader;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.emf.common.util.EList;

public class PostgresCatalogSchema
extends JDBCSchema {
    private final Object SEQUENCE_LOCK = new Object();
    private Boolean sequencesLoaded = Boolean.FALSE;
    private transient SoftReference sequenceLoaderRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            if (this.sequencesLoaded.booleanValue()) {
                this.sequencesLoaded = Boolean.FALSE;
            }
        }
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSequences() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            if (!this.sequencesLoaded.booleanValue()) {
                this.loadSequences();
            }
        }
        return super.getSequences();
    }

    protected final PostgresSequenceLoader getSequenceLoader() {
        if (this.sequenceLoaderRef == null || this.sequenceLoaderRef.get() == null) {
            this.sequenceLoaderRef = new SoftReference<PostgresSequenceLoader>(this.createSequenceLoader());
        }
        return (PostgresSequenceLoader)((Object)this.sequenceLoaderRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSequences() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getSequences();
                        ArrayList existingSequences = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getSequenceLoader().loadSequences((List)container, existingSequences);
                        this.getSequenceLoader().clearSequences(existingSequences);
                        this.sequencesLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    private PostgresSequenceLoader createSequenceLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLSchemaPackage.eINSTANCE.getSequence().getInstanceClassName());
        if (loader != null) {
            PostgresSequenceLoader sequenceLoader = (PostgresSequenceLoader)loader;
            sequenceLoader.setCatalogObject((ICatalogObject)this);
            return sequenceLoader;
        }
        return new PostgresSequenceLoader((ICatalogObject)this);
    }
}

