/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;

public class IngresTableConstraintDefinitionLoader
extends JDBCBaseLoader {
    private static final String CONSTRAINT_DEFINITION_QUERY = "SELECT text_segment FROM iiconstraints c WHERE c.schema_name = ? AND c.table_name = ? AND c.constraint_name = ? AND c.constraint_type = ? ORDER BY c.text_sequence";
    private static final String CONSTRAINT_DEFINITION_SEGMENT = "text_segment";

    public IngresTableConstraintDefinitionLoader() {
        this(null);
    }

    public IngresTableConstraintDefinitionLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public IngresTableConstraintDefinitionLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void loadCheckConstraintDefinition(String schemaName, String tableName, String constraintName, SearchCondition condition) {
        this.loadConstraintDefinition(schemaName, tableName, constraintName, "C", condition);
    }

    public void loadConstraintDefinition(String schemaName, String tableName, String constraintName, String constraintType, SearchCondition condition) {
        block6: {
            ResultSet rs = null;
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.getCatalogObject().getConnection().prepareStatement(CONSTRAINT_DEFINITION_QUERY);
                    stmt.setString(1, schemaName);
                    stmt.setString(2, tableName);
                    stmt.setString(3, constraintName);
                    stmt.setString(4, constraintType);
                    rs = stmt.executeQuery();
                    StringBuffer definitionBuf = new StringBuffer();
                    while (rs.next()) {
                        definitionBuf.append(rs.getString(CONSTRAINT_DEFINITION_SEGMENT));
                    }
                    condition.setSQL(definitionBuf.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoaderHelper.close(rs);
                    LoaderHelper.close(stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                LoaderHelper.close(rs);
                LoaderHelper.close(stmt);
                throw throwable;
            }
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
        }
    }
}

