/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.plan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public final class QEPLogExtractor {
    private static final QEPLogExtractor INSTANCE = new QEPLogExtractor();
    private static final String LINE_START = "DBMS TRACE: ";
    private transient BufferedReader logReader;

    private QEPLogExtractor() {
    }

    public static QEPLogExtractor getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skipAll() throws IOException {
        BufferedReader reader;
        BufferedReader bufferedReader = reader = this.getLogReader();
        synchronized (bufferedReader) {
            while (reader.readLine() != null) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] extractLastQEP() throws IOException {
        BufferedReader reader;
        BufferedReader bufferedReader = reader = this.getLogReader();
        synchronized (bufferedReader) {
            String line;
            ArrayList<String> messages = new ArrayList<String>();
            boolean insideQep = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(LINE_START)) {
                    if (!insideQep) {
                        insideQep = true;
                        messages.clear();
                    }
                    line = line.substring(LINE_START.length());
                    messages.add(line);
                    continue;
                }
                insideQep = false;
            }
            return messages.toArray(new String[0]);
        }
    }

    private BufferedReader getLogReader() throws IOException {
        if (this.logReader == null) {
            this.logReader = this.createReader(this.findLogFile());
        }
        return this.logReader;
    }

    private BufferedReader createReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    private File findLogFile() {
        File log = null;
        String file = System.getProperty("ingres.jdbc.trace.log");
        if (file != null) {
            log = new File(file);
        }
        return log;
    }
}

