/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.internal.zseries;

import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.IDatabaseRecognizer;

public class ZSeriesDatabaseRecognizer
implements IDatabaseRecognizer {
    public static final String PRODUCT = "DB2 UDB zSeries";
    public static final String VERSION7 = "V7";
    public static final String VERSION8_NewFunctionMode = "V8 (New-Function Mode)";
    public static final String VERSION8_CompatMode = "V8 (Compatibility Mode)";
    public static final String VERSION9_NewFunctionMode = "V9 (New-Function Mode)";
    public static final String VERSION9_CompatMode = "V9 (Compatibility Mode)";

    public DatabaseDefinition recognize(Connection connection) {
        try {
            String version = connection.getMetaData().getDatabaseProductVersion();
            if (version.startsWith("DSN07")) {
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION7);
            }
            if (version.startsWith("DSN08")) {
                char m = version.charAt(7);
                if (m > '4') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION8_NewFunctionMode);
                }
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION8_CompatMode);
            }
            if (version.startsWith("DSN09")) {
                char m = version.charAt(7);
                if (m > '4') {
                    return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION9_NewFunctionMode);
                }
                return DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(PRODUCT, VERSION9_CompatMode);
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

