/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ddl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DdlParser;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2MaterializedQueryTable;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;

public class LUWDdlParser
extends DB2DdlParser {
    public LUWDdlParser(DatabaseDefinition def) {
        super(def);
    }

    public DB2MaterializedQueryTable parseMQT(String mqtText) {
        int pos;
        DataModelElementFactory factory = this.def.getDataModelElementFactory();
        DB2MaterializedQueryTable mqt = (DB2MaterializedQueryTable)factory.create(LUWPackage.eINSTANCE.getLUWMaterializedQueryTable());
        String body = mqtText;
        String[] tokens = mqtText.split("\\s[Aa][Ss]\\s", 2);
        if (tokens.length > 1) {
            body = tokens[1].trim();
        }
        if ((pos = this.parseMQTFullStatement(body)) != -1) {
            body = body.substring(1, pos);
        }
        QueryExpression queryExpression = (QueryExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault());
        mqt.setQueryExpression(queryExpression);
        queryExpression.setSQL(body);
        return mqt;
    }

    public void parseTrigger(Trigger trigger, String triggerText) {
        DataModelElementFactory factory = this.def.getDataModelElementFactory();
        String body = triggerText;
        String whenClause = "";
        Pattern pattern1 = Pattern.compile("[\\s]*CREATE.*[\\s]+?TRIGGER(.*)ON(.*)[\\s]+?FOR[\\s]+?EACH[\\s]+?(.*)", 34);
        Matcher matcher1 = pattern1.matcher(triggerText);
        if (matcher1.matches()) {
            this.parseUpdateColumns(matcher1.group(1).trim(), trigger);
            this.parseReferencingCluase(matcher1.group(2).trim(), trigger);
            body = matcher1.group(3).trim();
            if (body.toUpperCase().startsWith("ROW")) {
                body = body.substring("ROW".length() + 1);
            } else if (body.toUpperCase().startsWith("STATEMENT")) {
                body = body.substring("STATEMENT".length() + 1);
            }
            Pattern pattern = Pattern.compile("[\\s]*MODE[\\s]+?DB2SQL(.*)", 34);
            Matcher matcher = pattern.matcher(body);
            if (matcher.matches()) {
                body = matcher.group(1).trim();
                int whenPos = this.parseWhenClause(body);
                if (whenPos >= 0) {
                    whenClause = body.substring(body.indexOf("(") + 1, whenPos);
                    body = body.substring(whenPos + 1).trim();
                }
            } else {
                int whenPos = this.parseWhenClause(body);
                if (whenPos >= 0) {
                    whenClause = body.substring(body.indexOf("(") + 1, whenPos);
                    body = body.substring(whenPos + 1).trim();
                }
            }
        }
        SearchCondition searchCondition = (SearchCondition)factory.create(SQLExpressionsPackage.eINSTANCE.getSearchConditionDefault());
        trigger.setWhen(searchCondition);
        ((SearchConditionDefault)searchCondition).setSQL(whenClause);
        SQLStatement sqlbody = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
        ((SQLStatementDefault)sqlbody).setSQL(body);
        trigger.getActionStatement().add((Object)sqlbody);
    }

    private int parseMQTFullStatement(String body) {
        int pos = -1;
        int matches = 0;
        int i = 0;
        while (i < body.length()) {
            if (body.charAt(i) == '(') {
                ++matches;
            } else if (body.charAt(i) == ')' && --matches == 0) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }
}

