/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogXmlSchemaDocument;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2ModelPackage;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2XMLSchema;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2XMLSchemaDocument;
import org.eclipse.datatools.enablement.ibm.db2.model.impl.DB2XMLSchemaImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;

public class LUWCatalogXmlSchema
extends DB2XMLSchemaImpl
implements ICatalogObject {
    private boolean dependencyLoaded = false;
    private boolean xmlSchemaDocLoaded = false;
    public static final String XSD_EXTENSION = ".xsd";

    public void refresh() {
        if (this.xmlSchemaDocLoaded) {
            this.xmlSchemaDocs.clear();
            this.xmlSchemaDocLoaded = false;
        }
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public EList getXmlSchemaDocs() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getXmlSchemaDocs();
        }
        if (!this.xmlSchemaDocLoaded) {
            this.loadXmlSchemaDocs();
        }
        return this.xmlSchemaDocs;
    }

    private synchronized void loadXmlSchemaDocs() {
        if (this.xmlSchemaDocLoaded) {
            return;
        }
        EList xmlSchemaDocList = super.getXmlSchemaDocs();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            LUWCatalogXmlSchema.loadXMLSchemaDocs(connection, xmlSchemaDocList, (DB2XMLSchema)this);
        }
        catch (Exception exception) {}
        this.xmlSchemaDocLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadXMLSchemaDocs(Connection connection, EList xmlSchemaDocList, DB2XMLSchema xmlSchema) throws SQLException {
        Object[] oldList = xmlSchemaDocList.toArray();
        xmlSchemaDocList.clear();
        ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(xmlSchema.getSchema().getDatabase());
        ConnectionFilter xmlSchemaDocFilter = connectionInfo.getFilter(String.valueOf(xmlSchema.getName()) + "::" + "DatatoolsXMLSchemaDocsFilterPredicate");
        if (xmlSchemaDocFilter == null) {
            xmlSchemaDocFilter = connectionInfo.getFilter("DatatoolsXMLSchemaDocsFilterPredicate");
        }
        String filterStr = "";
        if (xmlSchemaDocFilter != null) {
            filterStr = String.valueOf(filterStr) + "SCHEMALOCATION " + xmlSchemaDocFilter.getPredicate();
            filterStr = " AND (" + filterStr;
            filterStr = String.valueOf(filterStr) + ") ";
        }
        String query = "SELECT H.HTYPE, C.SCHEMALOCATION, C.TARGETNAMESPACE, C.COMPONENTID, C.STATUS, C.COMPONENT FROM SYSCAT.XSROBJECTCOMPONENTS C, SYSCAT.XSROBJECTHIERARCHIES H WHERE C.OBJECTNAME='" + xmlSchema.getName() + "' AND " + " C.OBJECTSCHEMA= '" + xmlSchema.getSchema().getName() + "' AND " + " C.COMPONENTID = H.COMPONENTID";
        if (xmlSchemaDocFilter != null) {
            query = String.valueOf(query) + filterStr;
        }
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            try {
                while (r.next()) {
                    Object xmlSchemaDoc = null;
                    String schemaLocation = r.getString("SCHEMALOCATION");
                    EClass metaclass = DB2ModelPackage.eINSTANCE.getDB2XMLSchemaDocument();
                    if (metaclass != null) {
                        String docName = null;
                        if (schemaLocation != null && !schemaLocation.trim().equals("")) {
                            docName = schemaLocation.toLowerCase().endsWith(XSD_EXTENSION) ? schemaLocation.substring(schemaLocation.lastIndexOf("/") + 1, schemaLocation.lastIndexOf(46)) : schemaLocation.substring(schemaLocation.lastIndexOf("/") + 1);
                        } else {
                            long componentId = r.getLong("COMPONENTID");
                            docName = String.valueOf(componentId);
                        }
                        Object element = LUWCatalogXmlSchema.findElement(oldList, docName, metaclass);
                        if (element != null) {
                            xmlSchemaDoc = (DB2XMLSchemaDocument)element;
                            ((ICatalogObject)xmlSchema).refresh();
                        } else {
                            xmlSchemaDoc = new LUWCatalogXmlSchemaDocument();
                            xmlSchemaDoc.setName(docName);
                            xmlSchemaDoc.setSchemaLocation(schemaLocation);
                        }
                        String targetNamespace = r.getString("TARGETNAMESPACE");
                        xmlSchemaDoc.setTargetNamespace(targetNamespace);
                        String htype = r.getString("HTYPE");
                        if (htype.equals("P")) {
                            xmlSchemaDoc.setPrimary(true);
                        }
                    }
                    xmlSchemaDocList.add(xmlSchemaDoc);
                    Blob xsd = r.getBlob("COMPONENT");
                    if (xsd == null) continue;
                    InputStream xsdStream = xsd.getBinaryStream();
                    String xmlschemaPath = xmlSchema.getName();
                    String path = String.valueOf(LUWCatalogSchema.getXSDSourceCacheRoot(connectionInfo, (Schema)xmlSchema.getSchema())) + xmlschemaPath;
                    File dir = new File(path);
                    dir.mkdirs();
                    File xsdFile = new File(dir, String.valueOf(xmlSchemaDoc.getName()) + XSD_EXTENSION);
                    FileOutputStream fos = new FileOutputStream(xsdFile);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    BufferedInputStream bis = new BufferedInputStream(xsdStream);
                    byte[] b = new byte[bis.available()];
                    bis.read(b);
                    bos.write(b);
                    bis.close();
                    bos.close();
                    xmlSchemaDoc.setFileName(String.valueOf(path) + File.separator + xmlSchemaDoc.getName() + XSD_EXTENSION);
                }
            }
            catch (Exception exception) {
                r.close();
                s.close();
            }
        }
        finally {
            r.close();
            s.close();
        }
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass && sqlObject instanceof ICatalogObject) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }
}

