/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DesignerLogger {
    public static final String PLUGIN_LOGGER_NAME = "org.eclipse.datatools.connectivity.oda.design.ui";
    private static HashMap sm_loggerMap = new HashMap();
    private Logger m_logger;

    public static DesignerLogger getInstance() {
        return DesignerLogger.getInstance(PLUGIN_LOGGER_NAME);
    }

    public static DesignerLogger getInstance(String loggerName) {
        DesignerLogger aLogHelper = (DesignerLogger)sm_loggerMap.get(loggerName);
        if (aLogHelper == null) {
            aLogHelper = new DesignerLogger(loggerName);
            sm_loggerMap.put(loggerName, aLogHelper);
        }
        return aLogHelper;
    }

    private DesignerLogger(String loggerName) {
        this.m_logger = Logger.getLogger(loggerName);
    }

    public boolean isLoggable(Level level) {
        return this.m_logger.isLoggable(level);
    }

    public boolean isLoggingEnterExitLevel() {
        return this.isLoggable(Level.FINER);
    }

    public void entering(String sourceClass, String sourceMethod) {
        this.m_logger.entering(sourceClass, sourceMethod);
    }

    public void entering(String sourceClass, String sourceMethod, int intParam) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        Integer param1 = new Integer(intParam);
        this.m_logger.entering(sourceClass, sourceMethod, param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        this.m_logger.entering(sourceClass, sourceMethod, param1);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        if (params == null) {
            this.m_logger.entering(sourceClass, sourceMethod, "<null>");
        } else {
            this.m_logger.entering(sourceClass, sourceMethod, params);
        }
    }

    public void exiting(String sourceClass, String sourceMethod) {
        this.m_logger.exiting(sourceClass, sourceMethod);
    }

    public void exiting(String sourceClass, String sourceMethod, int intParam) {
        if (!this.isLoggingEnterExitLevel()) {
            return;
        }
        Integer param1 = new Integer(intParam);
        this.exiting(sourceClass, sourceMethod, param1);
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        this.m_logger.exiting(sourceClass, sourceMethod, result);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        this.m_logger.logp(level, sourceClass, sourceMethod, msg);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        this.m_logger.logp(level, sourceClass, sourceMethod, msg, param1);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (params == null) {
            this.m_logger.logp(level, sourceClass, sourceMethod, msg, "<null>");
        } else {
            this.m_logger.logp(level, sourceClass, sourceMethod, msg, params);
        }
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable ex) {
        assert (ex != null);
        this.m_logger.logp(level, sourceClass, sourceMethod, msg, ex);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Throwable ex) {
        this.logp(Level.SEVERE, sourceClass, sourceMethod, msg, ex);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Throwable ex) {
        this.logp(Level.WARNING, sourceClass, sourceMethod, msg, ex);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Throwable ex) {
        this.logp(Level.INFO, sourceClass, sourceMethod, msg, ex);
    }
}

