/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.importexecutable;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.Messages;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ImportExecutablePageTwo
extends WizardPage {
    private Combo configTypes;
    private Text configurationName;
    private Label configurationNameLabel;
    private Button createLaunch;
    private Button existingProjectButton;
    private Text existingProjectName;
    private String filterPlatform;
    private boolean isCreateLaunchConfigurationSelected = true;
    private boolean isCreateNewProjectSelected = true;
    private Button newProjectButton;
    private Label newProjectLabel;
    private Text newProjectName;
    private Button searchButton;
    private AbstractImportExecutableWizard wizard;
    private boolean shouldUpdateButtons = true;

    public ImportExecutablePageTwo(AbstractImportExecutableWizard wizard) {
        super("ImportExecutablePageTwo");
        this.wizard = wizard;
        this.setTitle(Messages.ImportExecutablePageTwo_ChooseProject);
        this.setDescription(Messages.ImportExecutablePageTwo_ChooseExisting);
        this.filterPlatform = "*";
    }

    private void addLaunchConfigTypes() {
        ILaunchConfigurationType[] configTypeList = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int j = 0;
        int capp = 0;
        int i = 0;
        while (i < configTypeList.length) {
            ILaunchConfigurationType type = configTypeList[i];
            String configTypeName = type.getName();
            if (type.isPublic() && type.supportsMode("debug") && this.wizard.supportsConfigurationType(type)) {
                this.configTypes.add(configTypeName);
                if (type.getIdentifier().equals("org.eclipse.cdt.launch.applicationLaunchType")) {
                    capp = j;
                }
                ++j;
            }
            ++i;
        }
        this.configTypes.select(capp);
    }

    public void checkExecutableSettings() {
        String defaultName;
        this.shouldUpdateButtons = false;
        if (this.isCreateNewProjectSelected && (defaultName = this.wizard.getDefaultProjectName()).length() > 0) {
            ICProject cProject = CoreModel.getDefault().getCModel().getCProject(defaultName);
            if (cProject.exists()) {
                this.isCreateNewProjectSelected = false;
                this.existingProjectName.setText(defaultName);
                this.existingProjectButton.setSelection(true);
                this.newProjectButton.setSelection(false);
            } else {
                this.newProjectName.setText(defaultName);
            }
            this.setLaunchConfigurationName(defaultName);
        }
        this.updateControls();
        this.shouldUpdateButtons = true;
    }

    protected ICProject chooseCProject() {
        try {
            Object[] projects = this.getCProjects();
            CElementLabelProvider labelProvider = new CElementLabelProvider();
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
            dialog.setTitle("Select a Project");
            dialog.setMessage("Choose a project for the executable.");
            dialog.setElements(projects);
            ICProject cProject = this.getExistingCProject();
            if (cProject != null) {
                dialog.setInitialSelections(new Object[]{cProject});
            }
            if (dialog.open() == 0) {
                return (ICProject)dialog.getFirstResult();
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        this.newProjectButton = new Button(composite, 16);
        this.newProjectButton.setText(Messages.ImportExecutablePageTwo_NewProjectName);
        this.newProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageTwo.this.isCreateNewProjectSelected = ImportExecutablePageTwo.this.newProjectButton.getSelection();
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.newProjectName = new Text(composite, 2048);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.newProjectName.setLayoutData((Object)gridData);
        this.newProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        new Label(composite, 0);
        this.newProjectLabel = new Label(composite, 0);
        GridData gridData_1 = new GridData();
        gridData_1.horizontalSpan = 3;
        this.newProjectLabel.setLayoutData((Object)gridData_1);
        this.newProjectLabel.setText(Messages.ImportExecutablePageTwo_ProjectLabel);
        Label dummy2 = new Label(composite, 0);
        GridData gridData_2 = new GridData();
        gridData_2.horizontalSpan = 4;
        dummy2.setLayoutData((Object)gridData_2);
        this.existingProjectButton = new Button(composite, 16);
        this.existingProjectButton.setText(Messages.ImportExecutablePageTwo_ExistingProject);
        this.existingProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageTwo.this.isCreateNewProjectSelected = !ImportExecutablePageTwo.this.newProjectButton.getSelection();
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.existingProjectName = new Text(composite, 2048);
        GridData gridData_3 = new GridData(768);
        gridData_3.horizontalSpan = 2;
        this.existingProjectName.setLayoutData((Object)gridData_3);
        this.existingProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.searchButton = new Button(composite, 0);
        this.searchButton.setLayoutData((Object)new GridData());
        this.searchButton.setText(Messages.ImportExecutablePageTwo_Search);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICProject project = ImportExecutablePageTwo.this.chooseCProject();
                if (project == null) {
                    return;
                }
                String projectName = project.getElementName();
                ImportExecutablePageTwo.this.existingProjectName.setText(projectName);
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.newProjectButton.setSelection(true);
        Label label = new Label(composite, 258);
        GridData gridData_4 = new GridData(256);
        gridData_4.horizontalSpan = 4;
        label.setLayoutData((Object)gridData_4);
        Composite composite_1 = new Composite(composite, 0);
        GridData gridData_5 = new GridData();
        gridData_5.horizontalSpan = 4;
        composite_1.setLayoutData((Object)gridData_5);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite_1.setLayout((Layout)gridLayout_1);
        this.createLaunch = new Button(composite_1, 32);
        this.createLaunch.setText(Messages.ImportExecutablePageTwo_CreateLaunch);
        this.createLaunch.setSelection(true);
        this.createLaunch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExecutablePageTwo.this.isCreateLaunchConfigurationSelected = ImportExecutablePageTwo.this.createLaunch.getSelection();
                ImportExecutablePageTwo.this.setLaunchConfigurationName(ImportExecutablePageTwo.this.configurationName.getText().trim());
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.configTypes = new Combo(composite_1, 8);
        GridData gridData_6 = new GridData(256);
        gridData_6.horizontalSpan = 2;
        this.configTypes.setLayoutData((Object)gridData_6);
        this.configTypes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageTwo.this.setLaunchConfigurationName(ImportExecutablePageTwo.this.configurationName.getText().trim());
            }
        });
        this.configurationNameLabel = new Label(composite, 0);
        this.configurationNameLabel.setLayoutData((Object)new GridData(128));
        this.configurationNameLabel.setText(Messages.ImportExecutablePageTwo_Name);
        this.configurationName = new Text(composite, 2048);
        GridData gridData_7 = new GridData(256);
        gridData_7.horizontalSpan = 3;
        this.configurationName.setLayoutData((Object)gridData_7);
        this.configurationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportExecutablePageTwo.this.updateControls();
            }
        });
        this.addLaunchConfigTypes();
        this.updateControls();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), ICDebugHelpContextIds.IMPORT_EXECUTABLE_PAGE_TWO);
    }

    private ICProject[] getCProjects() throws CModelException {
        ICProject[] cproject = CoreModel.getDefault().getCModel().getCProjects();
        ArrayList<ICProject> list = new ArrayList<ICProject>(cproject.length);
        int i = 0;
        while (i < cproject.length) {
            ICDescriptor cdesciptor = null;
            try {
                cdesciptor = CCorePlugin.getDefault().getCProjectDescription((IProject)cproject[i].getResource(), false);
                if (cdesciptor != null) {
                    String projectPlatform = cdesciptor.getPlatform();
                    if (this.filterPlatform.equals("*") || projectPlatform.equals("*") || this.filterPlatform.equalsIgnoreCase(projectPlatform)) {
                        list.add(cproject[i]);
                    }
                } else {
                    list.add(cproject[i]);
                }
            }
            catch (CoreException e) {
                list.add(cproject[i]);
            }
            ++i;
        }
        return list.toArray(new ICProject[list.size()]);
    }

    protected ICProject getExistingCProject() {
        String projectName = this.existingProjectName.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(projectName);
        if (!cProject.exists()) {
            return null;
        }
        return cProject;
    }

    public String getExistingProjectName() {
        return this.existingProjectName.getText().trim();
    }

    public String getNewConfigurationName() {
        return this.configurationName.getText().trim();
    }

    public String getNewProjectName() {
        return this.newProjectName.getText().trim();
    }

    protected ILaunchConfigurationType getSelectedLaunchConfigurationType() {
        ILaunchConfigurationType result = null;
        String selectedTypeName = this.configTypes.getText();
        ILaunchConfigurationType[] configTypeList = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypeList.length) {
            if (selectedTypeName.equals(configTypeList[i].getName())) {
                result = configTypeList[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isCreateLaunchConfigurationSelected() {
        return this.isCreateLaunchConfigurationSelected;
    }

    public boolean isCreateNewProjectSelected() {
        return this.isCreateNewProjectSelected;
    }

    private void setLaunchConfigurationName(String defaultName) {
        this.configurationName.setText(DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(defaultName));
        this.updateControls();
    }

    protected void updateControls() {
        this.isCreateNewProjectSelected = this.newProjectButton.getSelection();
        this.searchButton.setEnabled(!this.isCreateNewProjectSelected);
        this.newProjectName.setEnabled(this.isCreateNewProjectSelected);
        this.existingProjectName.setEnabled(!this.isCreateNewProjectSelected);
        this.newProjectLabel.setEnabled(this.isCreateNewProjectSelected);
        this.configTypes.setEnabled(this.isCreateLaunchConfigurationSelected);
        this.configurationName.setEnabled(this.isCreateLaunchConfigurationSelected);
        this.configurationNameLabel.setEnabled(this.isCreateLaunchConfigurationSelected);
        if (this.shouldUpdateButtons && this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (this.isCreateNewProjectSelected()) {
            if (this.getNewProjectName().length() == 0) {
                this.setErrorMessage(Messages.ImportExecutablePageTwo_EnterProjectName);
                return false;
            }
            ICProject cProject = CoreModel.getDefault().getCModel().getCProject(this.getNewProjectName());
            if (cProject.exists()) {
                this.setErrorMessage(Messages.ImportExecutablePageTwo_ProjectAlreadyExists);
                return false;
            }
        } else if (!this.isCreateNewProjectSelected()) {
            ICProject project = this.getExistingCProject();
            if (project == null) {
                this.setErrorMessage(Messages.ImportExecutablePageTwo_BadProjectName);
                return false;
            }
            String[] executables = this.wizard.getImportExecutablePage().getSelectedExecutables();
            ArrayList<String> existingNames = new ArrayList<String>();
            String[] stringArray = executables;
            int n = executables.length;
            int n2 = 0;
            while (n2 < n) {
                String executable = stringArray[n2];
                IFile exeFile = this.getExecutableFile(project.getProject(), executable);
                if (exeFile.exists()) {
                    existingNames.add(exeFile.getName());
                }
                ++n2;
            }
            if (!existingNames.isEmpty()) {
                this.setWarningMessage(NLS.bind((String)Messages.ImportExecutablePageTwo_ExecutableAlreadyExists, (Object)StringUtil.join(existingNames, (String)", ")));
            }
        }
        if (this.isCreateLaunchConfigurationSelected() && this.getNewConfigurationName().length() == 0) {
            this.setErrorMessage(Messages.ImportExecutablePageTwo_EnterLaunchConfig);
            return false;
        }
        return super.isPageComplete();
    }

    private IFile getExecutableFile(IProject project, String executable) {
        IPath location = Path.fromOSString((String)executable);
        String name = location.toFile().getName();
        return project.getFile(name);
    }

    private void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }
}

