/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.cdt.debug.ui.breakpointactions.SoundAction;
import org.eclipse.cdt.debug.ui.breakpointactions.SoundActionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SoundActionComposite
extends Composite {
    private static final String[] soundFileExtensions = new String[]{"*.wav", "*.mid", "*.au", "*.aiff"};
    private Combo combo_1;
    private ModifyListener comboModifyListener = null;
    private File selectedSoundFile = null;
    private SoundActionPage soundActionPage;
    private Label soundFilePathLabel;
    private Button tryItButton;

    public SoundActionComposite(Composite parent, int style, SoundActionPage page) {
        super(parent, style);
        this.soundActionPage = page;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label playSoundLabel = new Label((Composite)this, 0);
        playSoundLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        playSoundLabel.setText(Messages.getString("SoundActionComposite.4"));
        this.combo_1 = new Combo((Composite)this, 8);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.combo_1.setLayoutData((Object)gridData);
        this.comboModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SoundActionComposite.this.combo_1.getText().length() > 0) {
                    String filePath = SoundActionComposite.this.combo_1.getText();
                    File soundFile = new File(filePath);
                    if (soundFile.exists()) {
                        SoundActionComposite.this.soundFilePathLabel.setText(filePath);
                        SoundActionComposite.this.tryItButton.setEnabled(true);
                        SoundActionComposite.this.selectedSoundFile = soundFile;
                    } else {
                        SoundActionComposite.this.soundFilePathLabel.setText(Messages.getString("SoundActionComposite.9"));
                        SoundActionComposite.this.tryItButton.setEnabled(false);
                    }
                }
            }
        };
        this.rebuildRecentSoundsCombo();
        this.combo_1.addModifyListener(this.comboModifyListener);
        final String mediaPath = page.getMediaPath();
        Button browseButton = new Button((Composite)this, 0);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String res;
                FileDialog dialog = new FileDialog(SoundActionComposite.this.getShell(), 0);
                dialog.setText(Messages.getString("SoundActionComposite.5"));
                dialog.setFilterExtensions(soundFileExtensions);
                if (mediaPath.length() > 0) {
                    dialog.setFilterPath(mediaPath);
                }
                if ((res = dialog.open()) != null) {
                    SoundActionComposite.this.setSoundFile(res);
                }
            }
        });
        browseButton.setText(Messages.getString("SoundActionComposite.6"));
        this.tryItButton = new Button((Composite)this, 0);
        this.tryItButton.setLayoutData((Object)new GridData());
        this.tryItButton.setText(Messages.getString("SoundActionComposite.7"));
        this.tryItButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File soundFile = new File(SoundActionComposite.this.soundFilePathLabel.getText());
                SoundActionComposite.this.playSoundFile(soundFile);
            }
        });
        this.soundFilePathLabel = new Label((Composite)this, 0);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 2;
        this.soundFilePathLabel.setLayoutData((Object)gridData_1);
        this.soundFilePathLabel.setText("");
        if (this.soundActionPage.getSoundAction().getSoundFile() != null) {
            this.setSoundFile(this.soundActionPage.getSoundAction().getSoundFile().getAbsolutePath());
        }
    }

    private void addRecentSound(File soundFile) {
        this.soundActionPage.addRecentSound(soundFile);
        this.rebuildRecentSoundsCombo();
    }

    protected void checkSubclass() {
    }

    public void dispose() {
        super.dispose();
    }

    public File getSoundFile() {
        return this.selectedSoundFile;
    }

    protected void playSoundFile(File soundFile) {
        SoundAction.playSoundFile(soundFile);
    }

    private void rebuildRecentSoundsCombo() {
        this.combo_1.removeAll();
        ArrayList<File> sortedSounds = new ArrayList<File>(this.soundActionPage.getRecentSounds());
        Collections.sort(sortedSounds);
        for (File element : sortedSounds) {
            this.combo_1.add(element.getAbsolutePath());
        }
    }

    private void setSoundFile(String filePath) {
        this.combo_1.removeModifyListener(this.comboModifyListener);
        File soundFile = new File(filePath);
        if (soundFile.exists()) {
            this.addRecentSound(soundFile);
            this.combo_1.setText(soundFile.getAbsolutePath());
            this.soundFilePathLabel.setText(filePath);
            this.tryItButton.setEnabled(true);
            this.selectedSoundFile = soundFile;
        } else {
            this.soundFilePathLabel.setText(Messages.getString("SoundActionComposite.9"));
            this.tryItButton.setEnabled(false);
        }
        this.combo_1.addModifyListener(this.comboModifyListener);
    }
}

