/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExecutablesViewCopyHandler
extends AbstractHandler {
    private Clipboard clipboard;

    private Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(Display.getDefault());
        }
        return this.clipboard;
    }

    public void dispose() {
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof Executable) {
                    Executable exe = (Executable)obj;
                    ps.println(exe.getName());
                    continue;
                }
                if (obj instanceof ITranslationUnit) {
                    ITranslationUnit tu = (ITranslationUnit)obj;
                    ps.println(tu.getLocation().toFile().getName());
                    continue;
                }
                ps.println(obj.toString());
            }
            ps.flush();
            try {
                baos.flush();
            }
            catch (IOException e) {
                throw new ExecutionException("", (Throwable)e);
            }
            Clipboard cp = this.getClipboard();
            cp.setContents(new Object[]{baos.toString().trim()}, new Transfer[]{TextTransfer.getInstance()});
        }
        return null;
    }
}

