/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.sourcelookup.CProjectSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SourceContainerWorkbenchAdapter
implements IWorkbenchAdapter {
    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        if (o instanceof MappingSourceContainer) {
            return CDebugImages.DESC_OBJS_PATH_MAPPING;
        }
        if (o instanceof MapEntrySourceContainer) {
            return CDebugImages.DESC_OBJS_PATH_MAP_ENTRY;
        }
        if (o instanceof CProjectSourceContainer) {
            ICProject cProject;
            IProject project = ((CProjectSourceContainer)o).getProject();
            if (project != null && (cProject = CCorePlugin.getDefault().getCoreModel().create(project)) != null) {
                return this.getImageDescriptor((ICElement)cProject);
            }
        } else if (o instanceof ProjectSourceContainer) {
            IProject project = ((ProjectSourceContainer)o).getProject();
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null) {
                return this.getImageDescriptor((ICElement)cProject);
            }
        }
        return null;
    }

    protected ImageDescriptor getImageDescriptor(ICElement element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getImageDescriptor((Object)element);
        }
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof MappingSourceContainer) {
            return String.valueOf(SourceLookupUIMessages.SourceContainerWorkbenchAdapter_0) + ((MappingSourceContainer)o).getName();
        }
        if (o instanceof MapEntrySourceContainer) {
            return ((MapEntrySourceContainer)o).getName();
        }
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getQualifiedName(IPath path) {
        StringBuilder buffer = new StringBuilder();
        String[] segments = path.segments();
        if (segments.length > 0) {
            buffer.append(path.lastSegment());
            if (segments.length > 1) {
                buffer.append(" - ");
                if (path.getDevice() != null) {
                    buffer.append(path.getDevice());
                }
                int i = 0;
                while (i < segments.length - 1) {
                    buffer.append(File.separatorChar);
                    buffer.append(segments[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
        return "";
    }
}

