/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTemplateTypeParameter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class PDOMTemplateParameterArray {
    public static long putArray(Database db, IPDOMCPPTemplateParameter[] params) throws CoreException {
        long block;
        int len = Math.min(params.length, 511);
        long p = block = db.malloc(2 + 8 * len);
        db.putShort(p, (short)len);
        p += 2L;
        int i = 0;
        while (i < len) {
            IPDOMCPPTemplateParameter elem = params[i];
            db.putRecPtr(p, elem == null ? 0L : elem.getRecord());
            ++i;
            p += 4L;
        }
        return block;
    }

    public static IPDOMCPPTemplateParameter[] getArray(PDOMNode parent, long rec) throws CoreException {
        PDOM pdom = parent.getPDOM();
        Database db = pdom.getDB();
        int len = db.getShort(rec);
        Assert.isTrue((len >= 0 && len <= 511 ? 1 : 0) != 0);
        if (len == 0) {
            return IPDOMCPPTemplateParameter.EMPTY_ARRAY;
        }
        rec += 2L;
        IPDOMCPPTemplateParameter[] result = new IPDOMCPPTemplateParameter[len];
        int i = 0;
        while (i < len) {
            long nodeRec = db.getRecPtr(rec);
            rec += 4L;
            result[i] = nodeRec == 0L ? null : (IPDOMCPPTemplateParameter)((Object)PDOMNode.load(pdom, nodeRec));
            ++i;
        }
        return result;
    }

    public static IPDOMCPPTemplateParameter[] createPDOMTemplateParameters(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateParameter[] origParams) throws CoreException, DOMException {
        IPDOMCPPTemplateParameter[] params = new IPDOMCPPTemplateParameter[origParams.length];
        int i = 0;
        while (i < origParams.length) {
            params[i] = PDOMTemplateParameterArray.createPDOMTemplateParameter(linkage, parent, origParams[i]);
            ++i;
        }
        return params;
    }

    public static IPDOMCPPTemplateParameter createPDOMTemplateParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateParameter origParam) throws CoreException, DOMException {
        PDOMCPPBinding param = null;
        if (origParam instanceof ICPPTemplateNonTypeParameter) {
            param = new PDOMCPPTemplateNonTypeParameter(linkage, parent, (ICPPTemplateNonTypeParameter)origParam);
        } else if (origParam instanceof ICPPTemplateTypeParameter) {
            param = new PDOMCPPTemplateTypeParameter(linkage, parent, (ICPPTemplateTypeParameter)origParam);
        } else if (origParam instanceof ICPPTemplateTemplateParameter) {
            param = new PDOMCPPTemplateTemplateParameter(linkage, parent, (ICPPTemplateTemplateParameter)origParam);
        }
        return param;
    }
}

