/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFriend;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPMemberBlock;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassType
extends PDOMCPPBinding
implements IPDOMCPPClassType,
IPDOMMemberOwner {
    private static final int FIRSTBASE = 32;
    private static final int MEMBERLIST = 36;
    private static final int FIRSTFRIEND = 66;
    private static final int KEY = 70;
    private static final int ANONYMOUS = 71;
    private static final int FINAL = 72;
    private static final int VISIBLE_TO_ADL_ONLY = 73;
    private static final int NO_DISCARD = 74;
    protected static final int RECORD_SIZE = 75;
    private PDOMCPPClassScope fScope;

    public PDOMCPPClassType(PDOMLinkage linkage, PDOMNode parent, ICPPClassType classType, boolean visibleToAdlOnly) throws CoreException {
        super(linkage, parent, classType.getNameCharArray());
        this.setKind(classType);
        this.setAnonymous(classType);
        this.setFinal(classType);
        this.setVisibleToAdlOnly(visibleToAdlOnly);
        this.setNoDiscard(classType);
    }

    public PDOMCPPClassType(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 75;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            this.setAnonymous(ct);
            this.setFinal(ct);
            this.setNoDiscard(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 70L, (byte)ct.getKey());
    }

    private void setAnonymous(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 71L, (byte)(ct.isAnonymous() ? 1 : 0));
    }

    private void setFinal(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 72L, (byte)(ct.isFinal() ? 1 : 0));
    }

    private void setNoDiscard(ICPPClassType ct) throws CoreException {
        this.getDB().putByte(this.record + 74L, (byte)(ct.isNoDiscard() ? 1 : 0));
    }

    @Override
    public void setVisibleToAdlOnly(boolean visibleToAdlOnly) throws CoreException {
        this.getDB().putByte(this.record + 73L, (byte)(visibleToAdlOnly ? 1 : 0));
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public final void addChild(PDOMNode member) throws CoreException {
        throw new UnsupportedOperationException("addMember should be called instead to add " + (member instanceof IBinding ? ((IBinding)((Object)member)).getName() : member.toString()) + " to " + this.getName());
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    @Override
    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMCPPMemberBlock list = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 36L);
        list.accept(visitor);
    }

    private PDOMCPPBase getFirstBase() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 32L);
        return rec != 0L ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        long rec = base != null ? base.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 32L, rec);
    }

    public void addBases(PDOMName classDefName, ICPPBase[] bases) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1L);
        ILinkage linkage = this.getLinkage();
        PDOMCPPBase firstBase = this.getFirstBase();
        ICPPBase[] iCPPBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            PDOMCPPBase nextBase = new PDOMCPPBase((PDOMLinkage)linkage, base, classDefName);
            nextBase.setNextBase(firstBase);
            firstBase = nextBase;
            ++n2;
        }
        this.setFirstBase(firstBase);
    }

    public void removeBases(PDOMName classDefName) throws CoreException {
        PDOM pdom = this.getPDOM();
        Database db = this.getDB();
        pdom.removeCachedResult(this.record + 1L);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase prevBase = null;
        long nameRec = classDefName.getRecord();
        boolean deleted = false;
        while (base != null) {
            PDOMCPPBase nextBase = base.getNextBase();
            long classDefRec = db.getRecPtr(base.getRecord() + 0L);
            if (classDefRec == nameRec) {
                deleted = true;
                base.delete();
            } else {
                if (deleted) {
                    deleted = false;
                    if (prevBase == null) {
                        this.setFirstBase(base);
                    } else {
                        prevBase.setNextBase(base);
                    }
                }
                prevBase = base;
            }
            base = nextBase;
        }
        if (deleted) {
            if (prevBase == null) {
                this.setFirstBase(null);
            } else {
                prevBase.setNextBase(null);
            }
        }
    }

    public void addFriend(PDOMCPPFriend friend) throws CoreException {
        PDOMCPPFriend firstFriend = this.getFirstFriend();
        friend.setNextFriend(firstFriend);
        this.setFirstFriend(friend);
    }

    private PDOMCPPFriend getFirstFriend() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 66L);
        return rec != 0L ? new PDOMCPPFriend((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstFriend(PDOMCPPFriend friend) throws CoreException {
        long rec = friend != null ? friend.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 66L, rec);
    }

    public void removeFriend(PDOMName pdomName) throws CoreException {
        PDOMCPPFriend friend = this.getFirstFriend();
        PDOMCPPFriend predecessor = null;
        long nameRec = pdomName.getRecord();
        while (friend != null) {
            PDOMName name = friend.getSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = friend;
            friend = friend.getNextFriend();
        }
        if (friend != null) {
            if (predecessor != null) {
                predecessor.setNextFriend(friend.getNextFriend());
            } else {
                this.setFirstFriend(friend.getNextFriend());
            }
            friend.delete();
        }
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        if (this.fScope == null) {
            this.fScope = new PDOMCPPClassScope(this);
        }
        return this.fScope;
    }

    @Override
    public int getKey() {
        try {
            return this.getDB().getByte(this.record + 70L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    @Override
    public boolean isAnonymous() {
        try {
            return this.getDB().getByte(this.record + 71L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean isFinal() {
        try {
            return this.getDB().getByte(this.record + 72L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean isNoDiscard() {
        try {
            return this.getDB().getByte(this.record + 74L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean isVisibleToAdlOnly() {
        try {
            return this.getDB().getByte(this.record + 73L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPClassType && !(type instanceof ProblemBinding)) {
            ICPPClassType ctype = (ICPPClassType)type;
            if (PDOMCPPClassType.getEquivalentKind(ctype) != PDOMCPPClassType.getEquivalentKind(this)) {
                return false;
            }
            char[] nchars = ctype.getNameCharArray();
            if (nchars.length == 0) {
                nchars = ASTTypeUtil.createNameForAnonymous(ctype);
            }
            if (nchars == null || !CharArrayUtils.equals(nchars, this.getNameCharArray())) {
                return false;
            }
            return SemanticUtil.haveSameOwner(this, ctype);
        }
        return false;
    }

    private static int getEquivalentKind(ICPPClassType classType) {
        int key = classType.getKey();
        return key == 3 ? 1 : key;
    }

    @Override
    public ICPPBase[] getBases() {
        Long key = this.record + 1L;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
        try {
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            ICPPConstructor[] constructors = visitor.getConstructors();
            return ClassTypeHelper.getAllConstructors(this, constructors);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    @Override
    public ICPPUsingDeclaration[] getUsingDeclarations() {
        try {
            PDOMClassUtil.UsingDeclarationCollector visitor = new PDOMClassUtil.UsingDeclarationCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getUsingDeclarations();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPUsingDeclaration.EMPTY_USING_DECL_ARRAY;
        }
    }

    @Override
    public IBinding[] getFriends() {
        try {
            ArrayList<IBinding> list = new ArrayList<IBinding>();
            PDOMCPPFriend friend = this.getFirstFriend();
            while (friend != null) {
                list.add(0, friend.getFriendSpecifier());
                friend = friend.getNextFriend();
            }
            return list.toArray(new IBinding[list.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IBinding.EMPTY_BINDING_ARRAY;
        }
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ClassTypeHelper.getMethods(this);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    @Override
    public IField[] getFields() {
        return ClassTypeHelper.getFields(this);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void addMember(PDOMNode member, int visibility) {
        try {
            PDOMCPPMemberBlock members = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 36L);
            members.addMember(member, visibility);
            PDOMCPPClassScope.updateCache(this, member);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public int getVisibility(IBinding member) {
        try {
            PDOMCPPMemberBlock members = new PDOMCPPMemberBlock((PDOMLinkage)this.getLinkage(), this.record + 36L);
            int visibility = members.getVisibility(member);
            if (visibility < 0) {
                throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
            }
            return visibility;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }
}

