/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TextEditUtil {
    private TextEditUtil() {
    }

    public static MultiTextEdit flatten(TextEdit edit) {
        MultiTextEdit result = new MultiTextEdit();
        TextEditUtil.flatten(edit, result);
        return result;
    }

    private static void flatten(TextEdit edit, MultiTextEdit result) {
        if (edit.hasChildren()) {
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                TextEdit child = children[i];
                child.getParent().removeChild(0);
                TextEditUtil.flatten(child, result);
                ++i;
            }
        } else if (!(edit instanceof MultiTextEdit)) {
            result.addChild(edit);
        }
    }

    public static TextEdit merge(TextEdit edit1, TextEdit edit2) {
        if (edit1 instanceof MultiTextEdit && !edit1.hasChildren()) {
            return edit2;
        }
        if (edit2 instanceof MultiTextEdit && !edit2.hasChildren()) {
            return edit1;
        }
        MultiTextEdit result = new MultiTextEdit();
        TextEditUtil.merge(edit1, edit2, result);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static void merge(TextEdit edit1, TextEdit edit2, MultiTextEdit result) {
        block18: {
            block17: {
                if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block17;
                multiTextEdit1 = (MultiTextEdit)edit1;
                if (!multiTextEdit1.hasChildren()) {
                    result.addChild(edit2);
                    return;
                }
                multiTextEdit2 = (MultiTextEdit)edit2;
                if (!multiTextEdit2.hasChildren()) {
                    result.addChild(edit1);
                    return;
                }
                children1 = multiTextEdit1.getChildren();
                children2 = multiTextEdit2.getChildren();
                i1 = 0;
                i2 = 0;
                ** GOTO lbl37
                {
                    edit1.removeChild(0);
                    result.addChild(children1[i1]);
                    ++i1;
                    do {
                        if (i1 < children1.length && children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                        if (i1 < children1.length) ** GOTO lbl27
                        break block0;
lbl-1000:
                        // 1 sources

                        {
                            edit2.removeChild(0);
                            result.addChild(children2[i2]);
                            ++i2;
lbl27:
                            // 2 sources

                            ** while (i2 < children2.length && children2[i2].getExclusiveEnd() < children1[i1].getOffset())
                        }
lbl28:
                        // 1 sources

                        if (i2 >= children2.length) break block0;
                        if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue;
                        edit1.removeChild(0);
                        edit2.removeChild(0);
                        TextEditUtil.merge(children1[i1], children2[i2], result);
                        ++i1;
                        ++i2;
lbl37:
                        // 3 sources

                    } while (i1 < children1.length && i2 < children2.length);
                }
                while (i1 < children1.length) {
                    edit1.removeChild(0);
                    result.addChild(children1[i1]);
                    ++i1;
                }
                while (i2 < children2.length) {
                    edit2.removeChild(0);
                    result.addChild(children2[i2]);
                    ++i2;
                }
                break block18;
            }
            if (edit1 instanceof MultiTextEdit) {
                children = edit1.getChildren();
                i = 0;
                while (children[i].getExclusiveEnd() < edit2.getOffset()) {
                    edit1.removeChild(0);
                    result.addChild(children[i]);
                    if (++i < children.length) continue;
                    result.addChild(edit2);
                    return;
                }
                edit1.removeChild(0);
                TextEditUtil.merge(children[i], edit2, result);
                ++i;
                while (i < children.length) {
                    edit1.removeChild(0);
                    result.addChild(children[i]);
                    ++i;
                }
            } else if (edit2 instanceof MultiTextEdit) {
                children = edit2.getChildren();
                i = 0;
                while (children[i].getExclusiveEnd() < edit1.getOffset()) {
                    edit2.removeChild(0);
                    result.addChild(children[i]);
                    if (++i < children.length) continue;
                    result.addChild(edit1);
                    return;
                }
                edit2.removeChild(0);
                TextEditUtil.merge(edit1, children[i], result);
                ++i;
                while (i < children.length) {
                    edit2.removeChild(0);
                    result.addChild(children[i]);
                    ++i;
                }
            } else if (edit1.getExclusiveEnd() < edit2.getOffset()) {
                result.addChild(edit1);
                result.addChild(edit2);
            } else {
                result.addChild(edit2);
                result.addChild(edit1);
            }
        }
    }

    public static int delta(TextEdit edit) {
        int delta = 0;
        TextEdit[] textEditArray = edit.getChildren();
        int n = textEditArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit child = textEditArray[n2];
            delta += TextEditUtil.delta(child);
            ++n2;
        }
        return delta += TextEditUtil.ownDelta(edit);
    }

    private static int ownDelta(TextEdit edit) {
        if (edit instanceof DeleteEdit || edit instanceof MoveSourceEdit) {
            return -edit.getLength();
        }
        if (edit instanceof InsertEdit) {
            return ((InsertEdit)edit).getText().length();
        }
        if (edit instanceof ReplaceEdit) {
            return ((ReplaceEdit)edit).getText().length() - edit.getLength();
        }
        if (edit instanceof CopyTargetEdit) {
            return ((CopyTargetEdit)edit).getSourceEdit().getLength();
        }
        if (edit instanceof MoveTargetEdit) {
            return ((MoveTargetEdit)edit).getSourceEdit().getLength();
        }
        return 0;
    }
}

