/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCaptureBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNodeFactory;

public class CPPASTInitCapture
extends CPPASTCaptureBase
implements ICPPASTInitCapture {
    private ICPPASTDeclarator fDeclarator;

    public CPPASTInitCapture(ICPPASTDeclarator declarator) {
        this.setDeclarator(declarator);
    }

    @Override
    public CPPASTInitCapture copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTInitCapture copy(IASTNode.CopyStyle style) {
        CPPASTInitCapture copy = new CPPASTInitCapture((ICPPASTDeclarator)this.fDeclarator.copy(style));
        copy.setIsByReference(false);
        return this.copy(copy, style);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitCaptures) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (visitor.shouldVisitDeclarations) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclarator != null && !this.fDeclarator.accept(visitor)) {
            return false;
        }
        if (visitor.shouldVisitDeclarations && visitor.leave(this) == 2) {
            return false;
        }
        return !visitor.shouldVisitCaptures || visitor.leave(this) != 2;
    }

    @Override
    public boolean capturesThisPointer() {
        return false;
    }

    @Override
    public int getRoleForName(IASTName name) {
        if (name == this.fDeclarator.getName()) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean isByReference() {
        IASTPointerOperator[] pointerOperators = this.fDeclarator.getPointerOperators();
        return pointerOperators.length == 1 && pointerOperators[0] instanceof ICPPASTReferenceOperator;
    }

    @Override
    public void setIsByReference(boolean value) {
        this.assertNotFrozen();
        boolean isReferenceCapture = this.isByReference();
        if (value && !isReferenceCapture) {
            this.fDeclarator.addPointerOperator(CPPNodeFactory.getDefault().newReferenceOperator(false));
        } else if (!value && isReferenceCapture) {
            ((CPPASTDeclarator)this.fDeclarator).removePointerOperator(this.fDeclarator.getPointerOperators()[0]);
        }
    }

    @Override
    public ICPPASTDeclarator getDeclarator() {
        return this.fDeclarator;
    }

    @Override
    public void setDeclarator(ICPPASTDeclarator declarator) {
        this.assertNotFrozen();
        Objects.requireNonNull(declarator, "An init capture declarator must not be null.");
        this.fDeclarator = declarator;
        this.fDeclarator.setParent(this);
        this.fDeclarator.setPropertyInParent(DECLARATOR);
    }

    @Override
    public IASTName getIdentifier() {
        return this.fDeclarator.getName();
    }

    @Override
    public void setIdentifier(IASTName identifier) {
        this.assertNotFrozen();
        Objects.requireNonNull(identifier, "An init capture must have an identifier.");
        this.fDeclarator.setName(identifier);
    }
}

