/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.core.runtime.CoreException;

public class CArrayType
implements ICArrayType,
ITypeContainer,
ISerializableType {
    IType type;
    private IASTExpression sizeExpression;
    private IValue value = IntegralValue.NOT_INITIALIZED;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;
    private boolean isStatic;
    private boolean isVariableSized;

    public CArrayType(IType type) {
        this.type = type;
    }

    public CArrayType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict, IValue size) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isRestrict = isRestrict;
        this.value = size;
    }

    public void setIsStatic(boolean val) {
        this.isStatic = val;
    }

    public void setIsVariableLength(boolean val) {
        this.isVariableSized = val;
    }

    @Override
    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICArrayType) {
            ICArrayType at = (ICArrayType)obj;
            if (this.isConst() != at.isConst()) {
                return false;
            }
            if (this.isRestrict() != at.isRestrict()) {
                return false;
            }
            if (this.isStatic() != at.isStatic()) {
                return false;
            }
            if (this.isVolatile() != at.isVolatile()) {
                return false;
            }
            if (this.isVariableLength() != at.isVariableLength()) {
                return false;
            }
            return at.getType().isSameType(this.type) && this.hasSameSize(at);
        }
        return false;
    }

    private boolean hasSameSize(IArrayType rhs) {
        IValue s2;
        IValue s1 = this.getSize();
        if (s1 == (s2 = rhs.getSize())) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return CharArrayUtils.equals(s1.getSignature(), s2.getSignature());
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public void setType(IType t) {
        this.type = t;
    }

    public void setModifier(ICASTArrayModifier mod) {
        this.isConst = mod.isConst();
        this.isVolatile = mod.isVolatile();
        this.isRestrict = mod.isRestrict();
        this.isStatic = mod.isStatic();
        this.isVariableSized = mod.isVariableSized();
        this.sizeExpression = mod.getConstantExpression();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isRestrict() {
        return this.isRestrict;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isVariableLength() {
        return this.isVariableSized;
    }

    @Override
    public IValue getSize() {
        if (this.value != IntegralValue.NOT_INITIALIZED) {
            return this.value;
        }
        if (this.sizeExpression == null) {
            this.value = null;
            return null;
        }
        this.value = ValueFactory.create(this.sizeExpression);
        return this.value;
    }

    @Override
    public boolean hasSize() {
        return this.value == IntegralValue.NOT_INITIALIZED ? this.sizeExpression != null : this.value != null;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 3;
        long nval = -1L;
        IValue val = null;
        if (this.isConst()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.isVolatile()) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        if (this.isRestrict()) {
            firstBytes = (short)(firstBytes | 0x80);
        }
        if (this.isStatic()) {
            firstBytes = (short)(firstBytes | 0x100);
        }
        if (this.isVariableLength()) {
            firstBytes = (short)(firstBytes | 0x200);
        }
        if ((val = this.getSize()) != null) {
            firstBytes = (short)(firstBytes | 0x400);
            Number num = val.numberValue();
            if (num != null && (nval = num.longValue()) >= 0L) {
                firstBytes = (short)(firstBytes | 0x800);
            }
        }
        buffer.putShort(firstBytes);
        if (nval >= 0L) {
            buffer.putLong(nval);
        } else if (val != null) {
            buffer.marshalValue(val);
        }
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IValue value = null;
        if ((firstBytes & 0x800) != 0) {
            value = IntegralValue.create(buffer.getLong());
        } else if ((firstBytes & 0x400) != 0) {
            value = buffer.unmarshalValue();
        }
        IType nested = buffer.unmarshalType();
        CArrayType result = new CArrayType(nested, (firstBytes & 0x20) != 0, (firstBytes & 0x40) != 0, (firstBytes & 0x80) != 0, value);
        result.setIsStatic((firstBytes & 0x100) != 0);
        result.setIsVariableLength((firstBytes & 0x200) != 0);
        return result;
    }

    @Override
    @Deprecated
    public IASTExpression getArraySizeExpression() {
        return this.sizeExpression;
    }
}

