/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.ExclusionInstance;
import org.eclipse.cdt.core.resources.ExclusionType;
import org.eclipse.cdt.core.resources.Messages;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class RefreshExclusion
implements Cloneable {
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    public static final String CONTRIBUTOR_ID_ATTRIBUTE_NAME = "contributorId";
    public static final String DISPLAY_STRING_ATTRIBUTE_NAME = "displayString";
    public static final String EXCLUSION_ELEMENT_NAME = "exclusion";
    public static final String EXCLUSION_TYPE_ATTRIBUTE_NAME = "exclusionType";
    public static final String EXTENSION_DATA_ELEMENT_NAME = "extensionData";
    public static final String FILE_VALUE = "FILE";
    public static final String FOLDER_VALUE = "FOLDER";
    public static final String INSTANCE_ELEMENT_NAME = "instance";
    public static final String RESOURCE_VALUE = "RESOURCE";
    public static final String WORKSPACE_PATH_ATTRIBUTE_NAME = "workspacePath";
    protected String fContributorId = "";
    protected List<ExclusionInstance> fExclusionInstanceList = new LinkedList<ExclusionInstance>();
    protected ExclusionType fExclusionType = ExclusionType.RESOURCE;
    protected List<RefreshExclusion> fNestedExclusions = new LinkedList<RefreshExclusion>();
    protected RefreshExclusion fParentExclusion;
    protected IResource fParentResource;

    public static synchronized List<RefreshExclusion> loadData(ICStorageElement parentElement, RefreshExclusion parentExclusion, IResource parentResource, RefreshScopeManager manager) throws CoreException {
        ICStorageElement[] children;
        LinkedList<RefreshExclusion> exclusions = new LinkedList<RefreshExclusion>();
        ICStorageElement[] iCStorageElementArray = children = parentElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (child.getName().equals(EXCLUSION_ELEMENT_NAME)) {
                ICStorageElement[] grandchildren;
                String className = child.getAttribute(CLASS_ATTRIBUTE_NAME);
                RefreshExclusion newExclusion = manager.getExclusionForClassName(className);
                if (newExclusion == null) {
                    throw new CoreException(CCorePlugin.createStatus(MessageFormat.format(Messages.RefreshExclusion_0, className)));
                }
                String exclusionTypeString = child.getAttribute(EXCLUSION_TYPE_ATTRIBUTE_NAME);
                if (exclusionTypeString != null) {
                    if (exclusionTypeString.equals(FILE_VALUE)) {
                        newExclusion.fExclusionType = ExclusionType.FILE;
                    } else if (exclusionTypeString.equals(FOLDER_VALUE)) {
                        newExclusion.fExclusionType = ExclusionType.FOLDER;
                    } else if (exclusionTypeString.equals(RESOURCE_VALUE)) {
                        newExclusion.fExclusionType = ExclusionType.RESOURCE;
                    }
                }
                newExclusion.fParentExclusion = parentExclusion;
                newExclusion.fParentResource = parentResource;
                newExclusion.fContributorId = child.getAttribute(CONTRIBUTOR_ID_ATTRIBUTE_NAME);
                ICStorageElement[] iCStorageElementArray2 = grandchildren = child.getChildren();
                int n3 = grandchildren.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICStorageElement grandchild = iCStorageElementArray2[n4];
                    if (grandchild.getName().equals(EXTENSION_DATA_ELEMENT_NAME)) {
                        newExclusion.loadExtendedData(grandchild);
                    } else if (grandchild.getName().equals(INSTANCE_ELEMENT_NAME)) {
                        ExclusionInstance instance = ExclusionInstance.loadInstanceData(grandchild, manager);
                        newExclusion.fExclusionInstanceList.add(instance);
                    }
                    ++n4;
                }
                List<RefreshExclusion> nestedExclusions = RefreshExclusion.loadData(child, newExclusion, null, manager);
                for (RefreshExclusion nestedExclusion : nestedExclusions) {
                    newExclusion.addNestedExclusion(nestedExclusion);
                }
                exclusions.add(newExclusion);
            }
            ++n2;
        }
        return exclusions;
    }

    public synchronized void addExclusionInstance(ExclusionInstance exclusionInstance) {
        exclusionInstance.setParentExclusion(this);
        this.fExclusionInstanceList.add(exclusionInstance);
    }

    public synchronized void addNestedExclusion(RefreshExclusion exclusion) {
        this.fNestedExclusions.add(exclusion);
        exclusion.setParentExclusion(this);
    }

    public synchronized String getContributorId() {
        return this.fContributorId;
    }

    public synchronized List<ExclusionInstance> getExclusionInstances() {
        return Collections.unmodifiableList(this.fExclusionInstanceList);
    }

    public synchronized ExclusionType getExclusionType() {
        return this.fExclusionType;
    }

    public abstract String getName();

    public synchronized List<RefreshExclusion> getNestedExclusions() {
        return Collections.unmodifiableList(this.fNestedExclusions);
    }

    public synchronized RefreshExclusion getParentExclusion() {
        return this.fParentExclusion;
    }

    public synchronized IResource getParentResource() {
        return this.fParentResource;
    }

    protected synchronized void loadExtendedData(ICStorageElement grandchild) {
    }

    public synchronized void persistData(ICStorageElement parentElement) {
        ICStorageElement exclusionElement = parentElement.createChild(EXCLUSION_ELEMENT_NAME);
        exclusionElement.setAttribute(CLASS_ATTRIBUTE_NAME, this.getClass().getName());
        String exclusionType = null;
        switch (this.getExclusionType()) {
            case FILE: {
                exclusionType = FILE_VALUE;
                break;
            }
            case FOLDER: {
                exclusionType = FOLDER_VALUE;
                break;
            }
            case RESOURCE: {
                exclusionType = RESOURCE_VALUE;
            }
        }
        if (exclusionType != null) {
            exclusionElement.setAttribute(EXCLUSION_TYPE_ATTRIBUTE_NAME, exclusionType);
        }
        exclusionElement.setAttribute(CONTRIBUTOR_ID_ATTRIBUTE_NAME, this.getContributorId());
        for (ExclusionInstance instance : this.fExclusionInstanceList) {
            instance.persistInstanceData(exclusionElement);
        }
        ICStorageElement extensionElement = exclusionElement.createChild(EXTENSION_DATA_ELEMENT_NAME);
        this.persistExtendedData(extensionElement);
        for (RefreshExclusion exclusion : this.fNestedExclusions) {
            exclusion.persistData(exclusionElement);
        }
    }

    protected synchronized void persistExtendedData(ICStorageElement extensionElement) {
    }

    public synchronized void removeExclusionInstance(ExclusionInstance exclusionInstance) {
        this.fExclusionInstanceList.remove(exclusionInstance);
    }

    public synchronized void removeNestedExclusion(RefreshExclusion exclusion) {
        this.fNestedExclusions.remove(exclusion);
    }

    public synchronized void setContributorId(String id) {
        this.fContributorId = id;
    }

    public synchronized void setExclusionType(ExclusionType exclusionType) {
        this.fExclusionType = exclusionType;
    }

    public synchronized void setParentExclusion(RefreshExclusion parent) {
        this.fParentExclusion = parent;
    }

    public synchronized void setParentResource(IResource parentResource) {
        this.fParentResource = parentResource;
    }

    public abstract boolean supportsExclusionInstances();

    public abstract boolean testExclusion(IResource var1);

    public synchronized boolean testExclusionChain(IResource resource) {
        boolean currentValue = this.testExclusion(resource);
        if (currentValue) {
            List<RefreshExclusion> nestedExclusions = this.getNestedExclusions();
            for (RefreshExclusion exclusion : nestedExclusions) {
                boolean nestedValue = exclusion.testExclusionChain(resource);
                if (!nestedValue) continue;
                currentValue = !currentValue;
                break;
            }
        }
        return currentValue;
    }

    protected void copyTo(RefreshExclusion destination) {
        destination.setContributorId(this.getContributorId());
        destination.setExclusionType(this.getExclusionType());
        destination.setParentResource(this.getParentResource());
        for (RefreshExclusion nestedExclusion : this.getNestedExclusions()) {
            RefreshExclusion clone = (RefreshExclusion)nestedExclusion.clone();
            clone.setParentExclusion(destination);
            destination.addNestedExclusion(clone);
        }
        for (ExclusionInstance next : this.getExclusionInstances()) {
            ExclusionInstance newInstance = new ExclusionInstance();
            newInstance.setDisplayString(next.getDisplayString());
            newInstance.setExclusionType(next.getExclusionType());
            newInstance.setParentExclusion(destination);
            newInstance.setResource(next.getResource());
            destination.addExclusionInstance(newInstance);
        }
    }

    public abstract Object clone();
}

