/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.actions;

import java.util.List;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.ui.actions.AbstractAutotoolsHandler;
import org.eclipse.cdt.internal.autotools.ui.actions.InvokeMessages;
import org.eclipse.cdt.internal.autotools.ui.actions.SingleInputDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Shell;

public class AutoreconfHandler
extends AbstractAutotoolsHandler {
    private static final String DEFAULT_OPTION = "";
    private static final String DEFAULT_COMMAND = "autoreconf";

    public Object execute(ExecutionEvent event) {
        return this.execute1(event);
    }

    @Override
    public void run(Shell activeShell) {
        IContainer container = this.getSelectedContainer();
        if (container == null) {
            return;
        }
        IPath execDir = this.getExecDir(container);
        String cwd = String.valueOf(InvokeMessages.getString("CWD")) + this.getCWD(container);
        SingleInputDialog optionDialog = new SingleInputDialog(activeShell, cwd, InvokeMessages.getString("InvokeAutoreconfAction.windowTitle.options"), InvokeMessages.getString("InvokeAutoreconfAction.message.options.otherOptions"), DEFAULT_OPTION, null);
        optionDialog.open();
        String rawArgList = optionDialog.getValue();
        List<String> optionsList = this.simpleParseOptions(rawArgList);
        String autoreconfCommand = null;
        IProject project = this.getSelectedContainer().getProject();
        try {
            autoreconfCommand = project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (autoreconfCommand == null) {
            autoreconfCommand = DEFAULT_COMMAND;
        }
        this.executeConsoleCommand(DEFAULT_COMMAND, autoreconfCommand, optionsList, execDir);
    }
}

