/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.InitializationContext;
import org.eclipse.buildship.core.ProjectConfigurator;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.core.internal.workspace.BuildCommandUpdater;
import org.eclipse.buildship.core.internal.workspace.BuildScriptLocationUpdater;
import org.eclipse.buildship.core.internal.workspace.ClasspathContainerUpdater;
import org.eclipse.buildship.core.internal.workspace.EclipseModelUtils;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainerUpdater;
import org.eclipse.buildship.core.internal.workspace.GradleFolderUpdater;
import org.eclipse.buildship.core.internal.workspace.JavaSourceSettingsUpdater;
import org.eclipse.buildship.core.internal.workspace.LibraryFilter;
import org.eclipse.buildship.core.internal.workspace.LinkedResourcesUpdater;
import org.eclipse.buildship.core.internal.workspace.OutputLocationUpdater;
import org.eclipse.buildship.core.internal.workspace.PersistentModelBuilder;
import org.eclipse.buildship.core.internal.workspace.ProjectNatureUpdater;
import org.eclipse.buildship.core.internal.workspace.SourceFolderUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseBuildCommand;
import org.gradle.tooling.model.eclipse.EclipseLinkedResource;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectNature;
import org.gradle.tooling.model.eclipse.EclipseSourceDirectory;

public class BaseConfigurator
implements ProjectConfigurator {
    private Map<File, EclipseProject> locationToProject;
    private GradleVersion gradleVersion;

    @Override
    public void init(InitializationContext context, IProgressMonitor monitor) {
        GradleBuild gradleBuild = context.getGradleBuild();
        try {
            Collection rootModels = gradleBuild.withConnection(connection -> {
                this.gradleVersion = GradleVersion.version(((BuildEnvironment)connection.getModel(BuildEnvironment.class)).getGradle().getGradleVersion());
                return EclipseModelUtils.queryModels(connection);
            }, monitor);
            this.locationToProject = rootModels.stream().flatMap(p -> HierarchicalElementUtils.getAll(p).stream()).collect(Collectors.toMap(p -> p.getProjectDirectory(), p -> p));
        }
        catch (Exception e) {
            context.error("Cannot Query Eclipse model", e);
        }
    }

    @Override
    public void configure(ProjectContext context, IProgressMonitor monitor) {
        IProject project = context.getProject();
        try {
            this.configure(context, project, monitor);
        }
        catch (CoreException e) {
            context.error("Failed to configure project " + project.getName(), (Exception)((Object)e));
        }
    }

    private void configure(ProjectContext context, IProject project, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(4);
        PersistentModelBuilder persistentModel = new PersistentModelBuilder(CorePlugin.modelPersistence().loadModel(project));
        EclipseProject model = this.lookupEclipseModel(project);
        progress.worked(1);
        persistentModel.gradleVersion(this.gradleVersion);
        BuildScriptLocationUpdater.update(model, persistentModel, (IProgressMonitor)progress.newChild(1));
        LinkedResourcesUpdater.update(project, (List<EclipseLinkedResource>)ImmutableList.copyOf((Collection)model.getLinkedResources()), persistentModel, (IProgressMonitor)progress.newChild(1));
        GradleFolderUpdater.update(project, model, persistentModel, (IProgressMonitor)progress.newChild(1));
        ProjectNatureUpdater.update(project, (List<EclipseProjectNature>)ImmutableList.copyOf((Collection)model.getProjectNatures()), persistentModel, (IProgressMonitor)progress.newChild(1));
        BuildCommandUpdater.update(project, (List<EclipseBuildCommand>)ImmutableList.copyOf((Collection)model.getBuildCommands()), persistentModel, (IProgressMonitor)progress.newChild(1));
        if (this.isJavaProject(model)) {
            this.synchronizeJavaProject(context, model, project, persistentModel, progress);
        } else {
            persistentModel.classpath((List<IClasspathEntry>)ImmutableList.of());
        }
        CorePlugin.modelPersistence().saveModel(persistentModel.build());
        CorePlugin.externalLaunchConfigurationManager().updateClasspathProviders(project);
    }

    private void synchronizeJavaProject(final ProjectContext context, final EclipseProject model, final IProject project, final PersistentModelBuilder persistentModel, SubMonitor progress) throws CoreException {
        JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                BaseConfigurator.this.synchronizeJavaProjectInTransaction(context, model, project, persistentModel, progress);
            }
        }, (IProgressMonitor)progress.newChild(1));
    }

    private void synchronizeJavaProjectInTransaction(ProjectContext context, EclipseProject model, IProject project, PersistentModelBuilder persistentModel, SubMonitor progress) throws JavaModelException, CoreException {
        progress.setWorkRemaining(7);
        CorePlugin.workspaceOperations().addNature(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)progress.newChild(1));
        IJavaProject javaProject = JavaCore.create((IProject)project);
        OutputLocationUpdater.update(context, javaProject, model, (IProgressMonitor)progress.newChild(1));
        SourceFolderUpdater.update(javaProject, (List<EclipseSourceDirectory>)ImmutableList.copyOf((Collection)model.getSourceDirectories()), (IProgressMonitor)progress.newChild(1));
        LibraryFilter.update(javaProject, model, (IProgressMonitor)progress.newChild(1));
        ClasspathContainerUpdater.update(javaProject, model, (IProgressMonitor)progress.newChild(1));
        JavaSourceSettingsUpdater.update(javaProject, model, (IProgressMonitor)progress.newChild(1));
        GradleClasspathContainerUpdater.updateFromModel(javaProject, model, this.locationToProject.values(), persistentModel, (IProgressMonitor)progress.newChild(1));
        persistentModel.hasAutoBuildTasks(model.hasAutoBuildTasks());
    }

    private boolean isJavaProject(EclipseProject model) {
        return model.getJavaSourceSettings() != null;
    }

    private EclipseProject lookupEclipseModel(IProject project) {
        IPath path = project.getLocation();
        if (path == null) {
            return null;
        }
        return this.locationToProject.get(path.toFile());
    }

    @Override
    public void unconfigure(ProjectContext context, IProgressMonitor monitor) {
        CorePlugin.modelPersistence().deleteModel(context.getProject());
    }
}

